/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.logsafe.logger.log4j;

import com.google.auto.service.AutoService;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.logger.log4j.Log4jSafeLoggerBridge;
import com.palantir.logsafe.logger.spi.SafeLoggerBridge;
import com.palantir.logsafe.logger.spi.SafeLoggerFactoryBridge;
import org.apache.logging.log4j.LogManager;

@AutoService(value={SafeLoggerFactoryBridge.class})
public final class Log4JSafeLoggerFactoryBridge
implements SafeLoggerFactoryBridge {
    private static final int DEFAULT_PRIORITY = 500;
    private final int priority = Log4JSafeLoggerFactoryBridge.isLog4jCoreAvailable() ? 500 : -500;

    public int priority() {
        return this.priority;
    }

    public SafeLoggerBridge get(@Safe Class<?> clazz) {
        return new Log4jSafeLoggerBridge(LogManager.getLogger(clazz));
    }

    public SafeLoggerBridge get(@Safe String name) {
        return new Log4jSafeLoggerBridge(LogManager.getLogger((String)name));
    }

    private static boolean isLog4jCoreAvailable() {
        try {
            Class.forName("org.apache.logging.log4j.core.LoggerContext");
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }
}

