/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.report;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

@JsonDeserialize(builder=Builder.class)
public final class TestDescription {
    private final Optional<String> testClass;
    private final Optional<String> displayName;
    private final Optional<String> method;
    private int memoizedHashCode;

    private TestDescription(Optional<String> testClass, Optional<String> displayName, Optional<String> method) {
        TestDescription.validateFields(testClass, displayName, method);
        this.testClass = testClass;
        this.displayName = displayName;
        this.method = method;
    }

    @JsonProperty(value="testClass")
    public Optional<String> getTestClass() {
        return this.testClass;
    }

    @JsonProperty(value="displayName")
    public Optional<String> getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="method")
    public Optional<String> getMethod() {
        return this.method;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof TestDescription && this.equalTo((TestDescription)other);
    }

    private boolean equalTo(TestDescription other) {
        return this.testClass.equals(other.testClass) && this.displayName.equals(other.displayName) && this.method.equals(other.method);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            this.memoizedHashCode = result = Objects.hash(this.testClass, this.displayName, this.method);
        }
        return result;
    }

    public String toString() {
        return "TestDescription{testClass: " + this.testClass + ", displayName: " + this.displayName + ", method: " + this.method + '}';
    }

    public static TestDescription of(String testClass, String displayName, String method) {
        return TestDescription.builder().testClass(Optional.of(testClass)).displayName(Optional.of(displayName)).method(Optional.of(method)).build();
    }

    private static void validateFields(Optional<String> testClass, Optional<String> displayName, Optional<String> method) {
        List<String> missingFields = null;
        missingFields = TestDescription.addFieldIfMissing(missingFields, testClass, "testClass");
        missingFields = TestDescription.addFieldIfMissing(missingFields, displayName, "displayName");
        if ((missingFields = TestDescription.addFieldIfMissing(missingFields, method, "method")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", new Arg[]{SafeArg.of((String)"missingFields", missingFields)});
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(3);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> testClass = Optional.empty();
        private Optional<String> displayName = Optional.empty();
        private Optional<String> method = Optional.empty();

        private Builder() {
        }

        public Builder from(TestDescription other) {
            this.testClass(other.getTestClass());
            this.displayName(other.getDisplayName());
            this.method(other.getMethod());
            return this;
        }

        @JsonSetter(value="testClass", nulls=Nulls.SKIP)
        public Builder testClass(@Nonnull Optional<String> testClass) {
            this.testClass = (Optional)Preconditions.checkNotNull(testClass, (String)"testClass cannot be null");
            return this;
        }

        public Builder testClass(@Nonnull String testClass) {
            this.testClass = Optional.of((String)Preconditions.checkNotNull((Object)testClass, (String)"testClass cannot be null"));
            return this;
        }

        @JsonSetter(value="displayName", nulls=Nulls.SKIP)
        public Builder displayName(@Nonnull Optional<String> displayName) {
            this.displayName = (Optional)Preconditions.checkNotNull(displayName, (String)"displayName cannot be null");
            return this;
        }

        public Builder displayName(@Nonnull String displayName) {
            this.displayName = Optional.of((String)Preconditions.checkNotNull((Object)displayName, (String)"displayName cannot be null"));
            return this;
        }

        @JsonSetter(value="method", nulls=Nulls.SKIP)
        public Builder method(@Nonnull Optional<String> method) {
            this.method = (Optional)Preconditions.checkNotNull(method, (String)"method cannot be null");
            return this;
        }

        public Builder method(@Nonnull String method) {
            this.method = Optional.of((String)Preconditions.checkNotNull((Object)method, (String)"method cannot be null"));
            return this;
        }

        public TestDescription build() {
            return new TestDescription(this.testClass, this.displayName, this.method);
        }
    }
}

