/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue;

import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.palantir.dialogue.MultimapAsMap;
import com.palantir.dialogue.RequestAttachments;
import com.palantir.dialogue.RequestBody;
import com.palantir.logsafe.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@ThreadSafe
public final class Request {
    private final ListMultimap<@NonNull String, @NonNull String> headerParams;
    private final ListMultimap<@NonNull String, @NonNull String> queryParams;
    private final ListMultimap<@NonNull String, @NonNull String> pathParams;
    private final Optional<RequestBody> body;
    private final RequestAttachments attachments;

    private Request(Builder builder) {
        this.body = builder.body;
        this.headerParams = builder.unmodifiableHeaderParams();
        this.queryParams = builder.unmodifiableQueryParams();
        this.pathParams = builder.unmodifiablePathParams();
        this.attachments = builder.attachments != null ? builder.attachments : RequestAttachments.create();
    }

    public ListMultimap<String, String> headerParams() {
        return this.headerParams;
    }

    public ListMultimap<String, String> queryParams() {
        return this.queryParams;
    }

    @Deprecated
    public Map<String, @Nullable String> pathParams() {
        return MultimapAsMap.of(this.pathParams);
    }

    public ListMultimap<String, String> pathParameters() {
        return this.pathParams;
    }

    public Optional<RequestBody> body() {
        return this.body;
    }

    public RequestAttachments attachments() {
        return this.attachments;
    }

    public String toString() {
        return "Request{headerParamsKeys=" + String.valueOf(this.headerParams.keySet()) + ", queryParams=" + String.valueOf(this.queryParams) + ", pathParams=" + String.valueOf(this.pathParams) + ", body=" + String.valueOf(this.body) + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Request request = (Request)other;
        return this.headerParams.equals(request.headerParams) && this.queryParams.equals(request.queryParams) && this.pathParams.equals(request.pathParams) && this.body.equals(request.body);
    }

    public int hashCode() {
        return Objects.hash(this.headerParams, this.queryParams, this.pathParams, this.body);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final Supplier<List<String>> MAP_VALUE_FACTORY = () -> new ArrayList(1);
        private static final int MUTABLE_HEADERS_MASK = 1;
        private static final int MUTABLE_QUERY_MASK = 2;
        private static final int MUTABLE_PATH_MASK = 4;
        private ListMultimap<String, String> headerParams = ImmutableListMultimap.of();
        private ListMultimap<String, String> queryParams = ImmutableListMultimap.of();
        private ListMultimap<String, String> pathParams = ImmutableListMultimap.of();
        private Optional<RequestBody> body = Optional.empty();
        private @Nullable RequestAttachments attachments;
        private int mutableCollectionsBitSet = 0;

        private Builder() {
        }

        public Builder from(Request existing) {
            Preconditions.checkNotNull((Object)existing, (String)"Request.build().from() requires a non-null instance");
            this.headerParams = existing.headerParams;
            this.queryParams = existing.queryParams;
            this.pathParams = existing.pathParams;
            this.attachments = existing.attachments;
            Optional<RequestBody> bodyOptional = existing.body();
            if (bodyOptional.isPresent()) {
                this.body(bodyOptional);
            }
            return this;
        }

        public Builder putHeaderParams(String key, String ... values) {
            return this.putAllHeaderParams(key, Arrays.asList(values));
        }

        public Builder putHeaderParams(String key, String value) {
            Preconditions.checkNotNull((Object)key, (String)"Header name must not be null");
            this.mutableHeaderParams().put((Object)key, (Object)value);
            return this;
        }

        public Builder headerParams(Multimap<String, ? extends String> entries) {
            this.mutableHeaderParams().clear();
            return this.putAllHeaderParams(entries);
        }

        public Builder putAllHeaderParams(String key, Iterable<String> values) {
            Preconditions.checkNotNull((Object)key, (String)"Header name must not be null");
            this.mutableHeaderParams().putAll((Object)key, values);
            return this;
        }

        public Builder putAllHeaderParams(Multimap<String, ? extends String> entries) {
            this.mutableHeaderParams().putAll(entries);
            return this;
        }

        public Builder putQueryParams(String key, String ... values) {
            Preconditions.checkNotNull((Object)key, (String)"Query parameter name must not be null");
            this.mutableQueryParams().putAll((Object)key, Arrays.asList(values));
            return this;
        }

        public Builder putQueryParams(String key, String value) {
            Preconditions.checkNotNull((Object)key, (String)"Query parameter name must not be null");
            Preconditions.checkNotNull((Object)value, (String)"Query parameter value must not be null");
            this.mutableQueryParams().put((Object)key, (Object)value);
            return this;
        }

        public Builder putQueryParams(Map.Entry<String, ? extends String> entry) {
            Preconditions.checkNotNull((Object)entry.getKey(), (String)"Query parameter name must not be null");
            Preconditions.checkNotNull((Object)entry.getValue(), (String)"Query parameter value must not be null");
            this.mutableQueryParams().put((Object)entry.getKey(), (Object)entry.getValue());
            return this;
        }

        public Builder queryParams(Multimap<String, ? extends String> entries) {
            this.mutableQueryParams().clear();
            return this.putAllQueryParams(entries);
        }

        public Builder putAllQueryParams(String key, Iterable<String> values) {
            Preconditions.checkNotNull((Object)key, (String)"Query parameter name must not be null");
            this.mutableQueryParams().putAll((Object)key, values);
            return this;
        }

        public Builder putAllQueryParams(Multimap<String, ? extends String> entries) {
            this.mutableQueryParams().putAll(entries);
            return this;
        }

        public Builder putPathParams(String key, String value) {
            Preconditions.checkNotNull((Object)key, (String)"Path parameter name must not be null");
            Preconditions.checkNotNull((Object)value, (String)"Path parameter value must not be null");
            this.mutablePathParams().put((Object)key, (Object)value);
            return this;
        }

        public Builder putPathParams(Map.Entry<String, ? extends String> entry) {
            Preconditions.checkNotNull((Object)entry.getKey(), (String)"Path parameter name must not be null");
            Preconditions.checkNotNull((Object)entry.getValue(), (String)"Path parameter value must not be null");
            this.mutablePathParams().put((Object)entry.getKey(), (Object)entry.getValue());
            return this;
        }

        public Builder pathParams(Map<String, ? extends String> entries) {
            this.mutablePathParams().clear();
            return this.putAllPathParams(entries);
        }

        public Builder putAllPathParams(String key, Iterable<String> values) {
            Preconditions.checkArgumentNotNull((Object)key, (String)"Path parameter name must not be null");
            this.mutablePathParams().putAll((Object)key, values);
            return this;
        }

        public Builder putAllPathParams(Map<String, ? extends String> entries) {
            entries.forEach((arg_0, arg_1) -> this.mutablePathParams().put(arg_0, arg_1));
            return this;
        }

        public Builder putAllPathParams(Multimap<String, ? extends String> entries) {
            this.mutablePathParams().putAll(entries);
            return this;
        }

        public Builder body(RequestBody value) {
            this.body = Optional.of((RequestBody)Preconditions.checkNotNull((Object)value, (String)"body"));
            return this;
        }

        public Builder body(Optional<? extends RequestBody> value) {
            this.body = value;
            return this;
        }

        private ListMultimap<String, String> mutableHeaderParams() {
            if (!this.isHeaderMutable()) {
                this.setHeaderMutable();
                ListMultimap mutable = Multimaps.newListMultimap(new TreeMap(String.CASE_INSENSITIVE_ORDER), MAP_VALUE_FACTORY);
                if (!this.headerParams.isEmpty()) {
                    this.headerParams.forEach((arg_0, arg_1) -> ((ListMultimap)mutable).put(arg_0, arg_1));
                }
                this.headerParams = mutable;
            }
            return this.headerParams;
        }

        private ListMultimap<String, String> mutableQueryParams() {
            if (!this.isQueryMutable()) {
                this.setQueryMutable();
                this.queryParams = Multimaps.newListMultimap(new LinkedHashMap(), MAP_VALUE_FACTORY);
            }
            return this.queryParams;
        }

        private ListMultimap<String, String> mutablePathParams() {
            if (!this.isPathMutable()) {
                this.setPathMutable();
                this.pathParams = ArrayListMultimap.create(this.pathParams);
            }
            return this.pathParams;
        }

        private ListMultimap<String, String> unmodifiableHeaderParams() {
            return this.isHeaderMutable() ? Multimaps.unmodifiableListMultimap(this.headerParams) : this.headerParams;
        }

        private ListMultimap<String, String> unmodifiableQueryParams() {
            return this.isQueryMutable() ? Multimaps.unmodifiableListMultimap(this.queryParams) : this.queryParams;
        }

        private ListMultimap<String, String> unmodifiablePathParams() {
            return this.isPathMutable() ? Multimaps.unmodifiableListMultimap(this.pathParams) : this.pathParams;
        }

        public Request build() {
            return new Request(this);
        }

        private boolean isQueryMutable() {
            return this.getBitFlag(2);
        }

        private void setQueryMutable() {
            this.setBitFlag(2);
        }

        private boolean isHeaderMutable() {
            return this.getBitFlag(1);
        }

        private void setHeaderMutable() {
            this.setBitFlag(1);
        }

        private boolean isPathMutable() {
            return this.getBitFlag(4);
        }

        private void setPathMutable() {
            this.setBitFlag(4);
        }

        private boolean getBitFlag(int mask) {
            return (this.mutableCollectionsBitSet & mask) != 0;
        }

        private void setBitFlag(int flag) {
            this.mutableCollectionsBitSet |= flag;
        }
    }
}

