/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.Immutable;
import com.palantir.dialogue.UrlBuilder;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeNullPointerException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;

@Immutable
public final class PathTemplate {
    private final ImmutableList<Segment> segments;

    private PathTemplate(Iterable<Segment> segments) {
        this.segments = ImmutableList.copyOf(segments);
        HashSet seenVariables = Sets.newHashSetWithExpectedSize((int)this.segments.size());
        for (Segment segment : segments) {
            if (segment.variable == null) continue;
            boolean seen = seenVariables.add(segment.variable);
            Preconditions.checkArgument((boolean)seen, (String)"Duplicate segment variable names not allowed", (Arg)SafeArg.of((String)"variable", (Object)segment.variable));
        }
    }

    public static PathTemplateBuilder builder() {
        return new PathTemplateBuilder();
    }

    public void fill(Map<String, String> parameters, UrlBuilder url) {
        int numVariableSegments = 0;
        for (Segment segment : this.segments) {
            if (segment.fixed != null) {
                url.pathSegment(segment.fixed);
                continue;
            }
            String variableSegment = parameters.get(segment.variable);
            if (variableSegment == null) {
                throw new SafeNullPointerException("Provided parameter map does not contain segment variable name", new Arg[]{SafeArg.of((String)"variable", (Object)segment.variable)});
            }
            url.pathSegment(variableSegment);
            ++numVariableSegments;
        }
        Verify.verify((numVariableSegments == parameters.size() ? 1 : 0) != 0, (String)"Too many parameters supplied, this is a bug", (Object[])new Object[0]);
    }

    public void fill(ListMultimap<String, String> parameters, UrlBuilder url) {
        for (Segment segment : this.segments) {
            if (segment.fixed != null) {
                url.pathSegment(segment.fixed);
                continue;
            }
            if (segment.variable == null) continue;
            url.pathSegments(parameters.get((Object)segment.variable));
        }
    }

    @Immutable
    public static final class Segment {
        private final @Nullable String fixed;
        private final @Nullable String variable;

        private Segment(@Nullable String fixed, @Nullable String variable) {
            this.fixed = fixed;
            this.variable = variable;
        }

        public static Segment fixed(String fixed) {
            return new Segment(fixed, null);
        }

        public static Segment variable(String variable) {
            return new Segment(null, variable);
        }
    }

    public static final class PathTemplateBuilder {
        private final List<Segment> segments = new ArrayList<Segment>();

        public PathTemplateBuilder fixed(String fixed) {
            this.segments.add(Segment.fixed(fixed));
            return this;
        }

        public PathTemplateBuilder variable(String variable) {
            this.segments.add(Segment.variable(variable));
            return this;
        }

        public PathTemplate build() {
            return new PathTemplate(this.segments);
        }
    }
}

