/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.util.Map;
import org.jspecify.annotations.Nullable;

final class MultimapAsMap {
    static <K, V> Map<K, @Nullable V> of(Multimap<K, V> multimap) {
        return Maps.transformValues((Map)multimap.asMap(), values -> {
            int size = values.size();
            if (size <= 1) {
                return Iterables.getOnlyElement((Iterable)values, null);
            }
            throw new SafeIllegalStateException("Multiple values are not allowed, use the multimap accessor instead", new Arg[]{SafeArg.of((String)"size", (Object)size), UnsafeArg.of((String)"values", (Object)values)});
        });
    }

    private MultimapAsMap() {
    }
}

