/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.errorprone.annotations.CheckReturnValue;
import com.palantir.logsafe.Preconditions;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class TargetUri
implements Comparable<TargetUri> {
    private final String uri;
    private final Optional<InetAddress> resolvedAddress;

    private TargetUri(String uri, Optional<InetAddress> resolvedAddress) {
        this.uri = (String)Preconditions.checkNotNull((Object)uri, (String)"uri");
        this.resolvedAddress = (Optional)Preconditions.checkNotNull(resolvedAddress, (String)"resolvedAddress");
    }

    public String uri() {
        return this.uri;
    }

    public Optional<InetAddress> resolvedAddress() {
        return this.resolvedAddress;
    }

    @Override
    public int compareTo(TargetUri other) {
        int result = this.uri.compareTo(other.uri);
        if (result != 0) {
            return result;
        }
        result = Arrays.compare(this.resolvedAddress.map(InetAddress::getAddress).orElse(null), other.resolvedAddress.map(InetAddress::getAddress).orElse(null));
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public String toString() {
        return "TargetUri{uri='" + this.uri + "', resolvedAddress=" + String.valueOf(this.resolvedAddress) + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TargetUri targetUri = (TargetUri)other;
        return this.uri.equals(targetUri.uri) && this.resolvedAddress.equals(targetUri.resolvedAddress);
    }

    public int hashCode() {
        int result = this.uri.hashCode();
        result = 31 * result + this.resolvedAddress.hashCode();
        return result;
    }

    public static TargetUri of(String uri) {
        return new TargetUri(uri, Optional.empty());
    }

    public static TargetUri of(String uri, @Nullable InetAddress resolvedAddress) {
        return new TargetUri(uri, Optional.ofNullable(resolvedAddress));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private @Nullable String uri;
        private @Nullable InetAddress resolvedAddress;

        private Builder() {
        }

        public Builder uri(String value) {
            this.uri = (String)Preconditions.checkNotNull((Object)value, (String)"uri");
            return this;
        }

        public Builder resolvedAddress(InetAddress value) {
            this.resolvedAddress = (InetAddress)Preconditions.checkNotNull((Object)value, (String)"resolvedAddress");
            return this;
        }

        public Builder resolvedAddress(Optional<InetAddress> value) {
            this.resolvedAddress = ((Optional)Preconditions.checkNotNull(value, (String)"resolvedAddress")).orElse(null);
            return this;
        }

        @CheckReturnValue
        public TargetUri build() {
            return TargetUri.of((String)Preconditions.checkNotNull((Object)this.uri, (String)"uri"), this.resolvedAddress);
        }
    }
}

