/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.core.CautiousIncreaseAggressiveDecreaseConcurrencyLimiter;
import com.palantir.dialogue.core.LimitedChannel;
import com.palantir.dialogue.core.NeverThrowLimitedChannel;
import com.palantir.dialogue.futures.DialogueFutures;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.Optional;

final class StickyConcurrencyLimitedChannel
implements LimitedChannel {
    private static final SafeLogger log = SafeLoggerFactory.get(StickyConcurrencyLimitedChannel.class);
    private final NeverThrowLimitedChannel delegate;
    private final CautiousIncreaseAggressiveDecreaseConcurrencyLimiter limiter;
    private final String channelNameForLogging;

    @VisibleForTesting
    StickyConcurrencyLimitedChannel(LimitedChannel delegate, CautiousIncreaseAggressiveDecreaseConcurrencyLimiter limiter, String channelNameForLogging) {
        this.delegate = new NeverThrowLimitedChannel(delegate);
        this.limiter = limiter;
        this.channelNameForLogging = channelNameForLogging;
    }

    @Override
    public Optional<ListenableFuture<Response>> maybeExecute(Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
        Optional<CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.Permit> maybePermit = this.limiter.acquire(limitEnforcement);
        if (maybePermit.isPresent()) {
            CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.Permit permit = maybePermit.get();
            this.logPermitAcquired();
            Optional<ListenableFuture<Response>> result = this.delegate.maybeExecute(endpoint, request, permit.isOnlyInFlight() ? LimitedChannel.LimitEnforcement.DANGEROUS_BYPASS_LIMITS : limitEnforcement);
            if (result.isPresent()) {
                DialogueFutures.addDirectCallback(result.get(), (FutureCallback)permit);
                return result;
            }
            maybePermit.get().dropped();
            return Optional.empty();
        }
        this.logPermitRefused();
        return Optional.empty();
    }

    static LimitedChannel create(LimitedChannel channel, String channelName) {
        return new StickyConcurrencyLimitedChannel(channel, new CautiousIncreaseAggressiveDecreaseConcurrencyLimiter(CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.Behavior.STICKY), channelName);
    }

    private void logPermitAcquired() {
        if (log.isDebugEnabled()) {
            log.debug("Sending {}/{} on {}", (Arg)SafeArg.of((String)"inflight", (Object)this.limiter.getInflight()), (Arg)SafeArg.of((String)"max", (Object)this.limiter.getLimit()), (Arg)SafeArg.of((String)"channel", (Object)this.channelNameForLogging));
        }
    }

    private void logPermitRefused() {
        if (log.isDebugEnabled()) {
            log.debug("Limited {} on {}", (Arg)SafeArg.of((String)"max", (Object)this.limiter.getLimit()), (Arg)SafeArg.of((String)"channel", (Object)this.channelNameForLogging));
        }
    }

    public String toString() {
        return "StickyConcurrencyLimitedChannel{delegate=" + String.valueOf(this.delegate) + ", name=" + this.channelNameForLogging + "}";
    }
}

