/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.RequestAttachmentKey;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.ResponseAttachmentKey;
import com.palantir.dialogue.core.LimitedChannel;
import com.palantir.dialogue.futures.DialogueFutures;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;

final class StickyAttachments {
    private static final ListenableFuture<Response> VALIDATION_FAILURE_EXCEPTION_FUTURE = Futures.immediateFailedFuture((Throwable)new SafeRuntimeException("Requested sticky token on request but token not present on response", new Arg[0]));
    @VisibleForTesting
    static final RequestAttachmentKey<Boolean> REQUEST_STICKY_TOKEN = RequestAttachmentKey.create(Boolean.class);
    @VisibleForTesting
    static final ResponseAttachmentKey<StickyTarget> STICKY_TOKEN = ResponseAttachmentKey.create(StickyTarget.class);
    @VisibleForTesting
    static final RequestAttachmentKey<StickyTarget> STICKY = RequestAttachmentKey.create(StickyTarget.class);

    private StickyAttachments() {
    }

    @CheckReturnValue
    static Optional<ListenableFuture<Response>> maybeAddStickyToken(LimitedChannel channel, Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
        if (StickyAttachments.hasRequestStickyToken(request)) {
            return channel.maybeExecute(endpoint, request, limitEnforcement).map(future -> DialogueFutures.transform((ListenableFuture)future, response -> {
                response.attachments().put(STICKY_TOKEN, channel::maybeExecute);
                return response;
            }));
        }
        return channel.maybeExecute(endpoint, request, limitEnforcement);
    }

    static Optional<ListenableFuture<Response>> maybeExecuteAndValidateRequestStickyToken(LimitedChannel channel, Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
        if (StickyAttachments.hasRequestStickyToken(request)) {
            return channel.maybeExecute(endpoint, request, limitEnforcement).map(future -> DialogueFutures.transformAsync((ListenableFuture)future, response -> {
                if (response.attachments().getOrDefault(STICKY_TOKEN, null) != null) {
                    return Futures.immediateFuture((Object)response);
                }
                response.close();
                return VALIDATION_FAILURE_EXCEPTION_FUTURE;
            }));
        }
        return channel.maybeExecute(endpoint, request, limitEnforcement);
    }

    static Optional<ListenableFuture<Response>> maybeExecuteOnSticky(LimitedChannel fallback, Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
        StickyTarget target = (StickyTarget)request.attachments().getOrDefault(STICKY, null);
        if (target != null) {
            return target.maybeExecute(endpoint, request, limitEnforcement);
        }
        return fallback.maybeExecute(endpoint, request, limitEnforcement);
    }

    static void requestStickyToken(Request request) {
        request.attachments().put(REQUEST_STICKY_TOKEN, (Object)true);
    }

    static Consumer<Request> copyStickyTarget(Response response) {
        StickyTarget stickyTarget = (StickyTarget)Preconditions.checkNotNull((Object)((StickyTarget)response.attachments().getOrDefault(STICKY_TOKEN, null)), (String)"stickyToken");
        return request -> request.attachments().put(STICKY, (Object)stickyTarget);
    }

    private static boolean hasRequestStickyToken(Request request) {
        return Boolean.TRUE.equals(request.attachments().getOrDefault(REQUEST_STICKY_TOKEN, (Object)false));
    }

    @VisibleForTesting
    static interface StickyTarget {
        public Optional<ListenableFuture<Response>> maybeExecute(Endpoint var1, Request var2, LimitedChannel.LimitEnforcement var3);
    }
}

