/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.errorprone.annotations.CompileTimeConstant;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeLoggable;
import com.palantir.logsafe.exceptions.SafeExceptions;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class SafeUnknownHostException
extends UnknownHostException
implements SafeLoggable {
    @CompileTimeConstant
    private final String logMessage;
    private final List<Arg<?>> arguments;

    SafeUnknownHostException(@CompileTimeConstant String message, Arg<?> ... arguments) {
        super(SafeExceptions.renderMessage((String)message, arguments));
        this.logMessage = message;
        this.arguments = Collections.unmodifiableList(Arrays.asList(arguments));
    }

    @Safe
    public String getLogMessage() {
        return this.logMessage;
    }

    public List<Arg<?>> getArgs() {
        return this.arguments;
    }
}

