/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.dialogue.EndpointChannel;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.Response;

final class RetryAdvertisementChannel
implements EndpointChannel {
    @VisibleForTesting
    static final String CLIENT_CAN_RETRY_HEADER = "Client-Can-Retry";
    private static final String CLIENT_CAN_RETRY_VALUE = "true";
    private final EndpointChannel delegate;

    RetryAdvertisementChannel(EndpointChannel delegate) {
        this.delegate = delegate;
    }

    public ListenableFuture<Response> execute(Request request) {
        return this.delegate.execute(RetryAdvertisementChannel.augment(request));
    }

    private static Request augment(Request input) {
        if (input.headerParams().containsKey((Object)CLIENT_CAN_RETRY_HEADER)) {
            return input;
        }
        return Request.builder().from(input).putHeaderParams(CLIENT_CAN_RETRY_HEADER, CLIENT_CAN_RETRY_VALUE).build();
    }

    public String toString() {
        return "RetryAdvertisementChannel{" + String.valueOf(this.delegate) + "}";
    }
}

