/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.annotations.VisibleForTesting;
import com.palantir.conjure.java.api.errors.QosReason;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.core.DialogueQosReasonDecoder;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

final class Responses {
    private static final SafeLogger log = SafeLoggerFactory.get(Responses.class);
    @VisibleForTesting
    static final String PROXY_UPSTREAM_REQUEST_ATTEMPTS = "Proxy-Upstream-Request-Attempts";

    static boolean isRetryOther(@Nullable Response response) {
        return response != null && response.code() == 308 && response.getFirstHeader("Location").isPresent();
    }

    static boolean isTooManyRequests(@Nullable Response response) {
        return response != null && response.code() == 429;
    }

    static boolean isUnavailable(@Nullable Response response) {
        return response != null && response.code() == 503;
    }

    static boolean isQosStatus(@Nullable Response response) {
        return Responses.isRetryOther(response) || Responses.isTooManyRequests(response) || Responses.isUnavailable(response);
    }

    static boolean isQosDueToCustom(@Nullable Response result) {
        if (result == null || !Responses.isQosStatus(result)) {
            return false;
        }
        QosReason reason = DialogueQosReasonDecoder.parse(result);
        return reason.dueTo().isPresent() && QosReason.DueTo.CUSTOM.equals(reason.dueTo().get());
    }

    static boolean isRetryableQos(Response result) {
        if (!Responses.isQosStatus(result)) {
            return false;
        }
        QosReason reason = DialogueQosReasonDecoder.parse(result);
        return reason.retryHint().isEmpty() || !QosReason.RetryHint.DO_NOT_RETRY.equals(reason.retryHint().get());
    }

    static boolean isServerErrorRange(@Nullable Response response) {
        return response == null || response.code() / 100 == 5;
    }

    static boolean isInternalServerError(@Nullable Response response) {
        return response == null || response.code() == 500;
    }

    static boolean isSuccess(@Nullable Response response) {
        return response != null && response.code() / 100 == 2;
    }

    static boolean isClientError(@Nullable Response response) {
        return response != null && response.code() / 100 == 4;
    }

    static int getProxyUpstreamRequestAttempts(Response response) {
        Optional maybeProxyUpstreamRequestAttempts = response.getFirstHeader(PROXY_UPSTREAM_REQUEST_ATTEMPTS);
        if (maybeProxyUpstreamRequestAttempts.isPresent()) {
            String proxyUpstreamRequestAttempts = (String)maybeProxyUpstreamRequestAttempts.get();
            try {
                int parsed = Integer.parseInt(proxyUpstreamRequestAttempts.trim());
                if (parsed >= 0) {
                    return parsed;
                }
                log.warn("Received an unexpected negative proxy upstream request attempts value, using zero", (Arg)SafeArg.of((String)"proxyUpstreamRequestAttempts", (Object)proxyUpstreamRequestAttempts));
            }
            catch (NumberFormatException e) {
                log.warn("Failed to parse proxy upstream request attempts, assuming zero", (Arg)SafeArg.of((String)"proxyUpstreamRequestAttempts", (Object)proxyUpstreamRequestAttempts), (Throwable)e);
            }
        }
        return 0;
    }

    private Responses() {
    }
}

