/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.dialogue.EndpointChannel;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.Response;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;

final class NeverThrowEndpointChannel
implements EndpointChannel {
    private static final SafeLogger log = SafeLoggerFactory.get(NeverThrowEndpointChannel.class);
    private final EndpointChannel proceed;

    NeverThrowEndpointChannel(EndpointChannel proceed) {
        this.proceed = proceed;
    }

    public ListenableFuture<Response> execute(Request request) {
        try {
            return this.proceed.execute(request);
        }
        catch (Error | RuntimeException e) {
            log.error("Dialogue channels should never throw. This may be a bug in the channel implementation", e);
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public String toString() {
        return "NeverThrowEndpointChannel{" + String.valueOf(this.proceed) + "}";
    }
}

