/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.dialogue.Channel;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.Response;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;

final class NeverThrowChannel
implements Channel {
    private static final SafeLogger log = SafeLoggerFactory.get(NeverThrowChannel.class);
    private final Channel delegate;

    NeverThrowChannel(Channel delegate) {
        this.delegate = delegate;
    }

    public ListenableFuture<Response> execute(Endpoint endpoint, Request request) {
        try {
            return this.delegate.execute(endpoint, request);
        }
        catch (Error | RuntimeException e) {
            log.error("Dialogue channels should never throw. This may be a bug in the channel implementation", e);
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public String toString() {
        return "NeverThrowChannel{" + String.valueOf(this.delegate) + "}";
    }
}

