/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.dialogue.core.DialogueNodeSelectionStrategy;
import com.palantir.dialogue.core.LimitedChannel;
import com.palantir.dialogue.core.NodeSelectionStrategyChannel;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NodeSelectionStrategyChannel.NodeSelectionChannel", generator="Immutables")
@Immutable
final class ImmutableNodeSelectionChannel
implements NodeSelectionStrategyChannel.NodeSelectionChannel {
    private final DialogueNodeSelectionStrategy strategy;
    private final LimitedChannel channel;

    private ImmutableNodeSelectionChannel(DialogueNodeSelectionStrategy strategy, LimitedChannel channel) {
        this.strategy = strategy;
        this.channel = channel;
    }

    @Override
    public DialogueNodeSelectionStrategy strategy() {
        return this.strategy;
    }

    @Override
    public LimitedChannel channel() {
        return this.channel;
    }

    public final ImmutableNodeSelectionChannel withStrategy(DialogueNodeSelectionStrategy value) {
        DialogueNodeSelectionStrategy newValue = Objects.requireNonNull(value, "strategy");
        if (this.strategy == newValue) {
            return this;
        }
        return new ImmutableNodeSelectionChannel(newValue, this.channel);
    }

    public final ImmutableNodeSelectionChannel withChannel(LimitedChannel value) {
        if (this.channel == value) {
            return this;
        }
        LimitedChannel newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableNodeSelectionChannel(this.strategy, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeSelectionChannel && this.equalsByValue((ImmutableNodeSelectionChannel)another);
    }

    private boolean equalsByValue(ImmutableNodeSelectionChannel another) {
        return this.strategy.equals((Object)another.strategy) && this.channel.equals(another.channel);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.strategy.hashCode();
        h += (h << 5) + this.channel.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NodeSelectionChannel").omitNullValues().add("strategy", (Object)this.strategy).add("channel", (Object)this.channel).toString();
    }

    public static ImmutableNodeSelectionChannel copyOf(NodeSelectionStrategyChannel.NodeSelectionChannel instance) {
        if (instance instanceof ImmutableNodeSelectionChannel) {
            return (ImmutableNodeSelectionChannel)instance;
        }
        return new NodeSelectionStrategyChannel.NodeSelectionChannel.Builder().from(instance).build();
    }

    @Generated(from="NodeSelectionStrategyChannel.NodeSelectionChannel", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_STRATEGY = 1L;
        private static final long INIT_BIT_CHANNEL = 2L;
        private long initBits = 3L;
        private @Nullable DialogueNodeSelectionStrategy strategy;
        private @Nullable LimitedChannel channel;

        public Builder() {
            if (!(this instanceof NodeSelectionStrategyChannel.NodeSelectionChannel.Builder)) {
                throw new UnsupportedOperationException("Use: new NodeSelectionStrategyChannel.NodeSelectionChannel.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final NodeSelectionStrategyChannel.NodeSelectionChannel.Builder from(NodeSelectionStrategyChannel.NodeSelectionChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.strategy(instance.strategy());
            this.channel(instance.channel());
            return (NodeSelectionStrategyChannel.NodeSelectionChannel.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NodeSelectionStrategyChannel.NodeSelectionChannel.Builder strategy(DialogueNodeSelectionStrategy strategy) {
            this.strategy = Objects.requireNonNull(strategy, "strategy");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (NodeSelectionStrategyChannel.NodeSelectionChannel.Builder)this;
        }

        @CanIgnoreReturnValue
        public final NodeSelectionStrategyChannel.NodeSelectionChannel.Builder channel(LimitedChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (NodeSelectionStrategyChannel.NodeSelectionChannel.Builder)this;
        }

        public ImmutableNodeSelectionChannel build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeSelectionChannel(this.strategy, this.channel);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("strategy");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("channel");
            }
            return "Cannot build NodeSelectionChannel, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

