/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.dialogue.core.DeprecationWarningChannel;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeprecationWarningChannel.LoggingRateLimiterKey", generator="Immutables")
@Immutable
final class ImmutableLoggingRateLimiterKey
implements DeprecationWarningChannel.LoggingRateLimiterKey {
    private final String channelName;
    private final String serviceName;
    private final String endpointName;

    private ImmutableLoggingRateLimiterKey(String channelName, String serviceName, String endpointName) {
        this.channelName = Objects.requireNonNull(channelName, "channelName");
        this.serviceName = Objects.requireNonNull(serviceName, "serviceName");
        this.endpointName = Objects.requireNonNull(endpointName, "endpointName");
    }

    private ImmutableLoggingRateLimiterKey(ImmutableLoggingRateLimiterKey original, String channelName, String serviceName, String endpointName) {
        this.channelName = channelName;
        this.serviceName = serviceName;
        this.endpointName = endpointName;
    }

    @Override
    public String channelName() {
        return this.channelName;
    }

    @Override
    public String serviceName() {
        return this.serviceName;
    }

    @Override
    public String endpointName() {
        return this.endpointName;
    }

    public final ImmutableLoggingRateLimiterKey withChannelName(String value) {
        String newValue = Objects.requireNonNull(value, "channelName");
        if (this.channelName.equals(newValue)) {
            return this;
        }
        return new ImmutableLoggingRateLimiterKey(this, newValue, this.serviceName, this.endpointName);
    }

    public final ImmutableLoggingRateLimiterKey withServiceName(String value) {
        String newValue = Objects.requireNonNull(value, "serviceName");
        if (this.serviceName.equals(newValue)) {
            return this;
        }
        return new ImmutableLoggingRateLimiterKey(this, this.channelName, newValue, this.endpointName);
    }

    public final ImmutableLoggingRateLimiterKey withEndpointName(String value) {
        String newValue = Objects.requireNonNull(value, "endpointName");
        if (this.endpointName.equals(newValue)) {
            return this;
        }
        return new ImmutableLoggingRateLimiterKey(this, this.channelName, this.serviceName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLoggingRateLimiterKey && this.equalsByValue((ImmutableLoggingRateLimiterKey)another);
    }

    private boolean equalsByValue(ImmutableLoggingRateLimiterKey another) {
        return this.channelName.equals(another.channelName) && this.serviceName.equals(another.serviceName) && this.endpointName.equals(another.endpointName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.channelName.hashCode();
        h += (h << 5) + this.serviceName.hashCode();
        h += (h << 5) + this.endpointName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LoggingRateLimiterKey").omitNullValues().add("channelName", (Object)this.channelName).add("serviceName", (Object)this.serviceName).add("endpointName", (Object)this.endpointName).toString();
    }

    public static ImmutableLoggingRateLimiterKey of(String channelName, String serviceName, String endpointName) {
        return new ImmutableLoggingRateLimiterKey(channelName, serviceName, endpointName);
    }

    public static ImmutableLoggingRateLimiterKey copyOf(DeprecationWarningChannel.LoggingRateLimiterKey instance) {
        if (instance instanceof ImmutableLoggingRateLimiterKey) {
            return (ImmutableLoggingRateLimiterKey)instance;
        }
        return ImmutableLoggingRateLimiterKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeprecationWarningChannel.LoggingRateLimiterKey", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_NAME = 1L;
        private static final long INIT_BIT_SERVICE_NAME = 2L;
        private static final long INIT_BIT_ENDPOINT_NAME = 4L;
        private long initBits = 7L;
        private @Nullable String channelName;
        private @Nullable String serviceName;
        private @Nullable String endpointName;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DeprecationWarningChannel.LoggingRateLimiterKey instance) {
            Objects.requireNonNull(instance, "instance");
            this.channelName(instance.channelName());
            this.serviceName(instance.serviceName());
            this.endpointName(instance.endpointName());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder channelName(String channelName) {
            this.channelName = Objects.requireNonNull(channelName, "channelName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serviceName(String serviceName) {
            this.serviceName = Objects.requireNonNull(serviceName, "serviceName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder endpointName(String endpointName) {
            this.endpointName = Objects.requireNonNull(endpointName, "endpointName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableLoggingRateLimiterKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLoggingRateLimiterKey(null, this.channelName, this.serviceName, this.endpointName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("serviceName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("endpointName");
            }
            return "Cannot build LoggingRateLimiterKey, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

