/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.github.benmanes.caffeine.cache.Ticker;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.conjure.java.client.config.HostEventsSink;
import com.palantir.dialogue.Channel;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.core.Config;
import com.palantir.dialogue.futures.DialogueFutures;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;

final class HostMetricsChannel
implements Channel {
    private final Channel delegate;
    private final Ticker clock;
    private final HostEventsSink.HostEventCallback hostEventCallback;

    private HostMetricsChannel(Channel delegate, HostEventsSink hostMetrics, Ticker ticker, String serviceName, String host, int port) {
        this.delegate = (Channel)Preconditions.checkNotNull((Object)delegate, (String)"Channel is required");
        this.clock = ticker;
        this.hostEventCallback = ((HostEventsSink)Preconditions.checkNotNull((Object)hostMetrics, (String)"HostEventsSink is required")).callback((String)Preconditions.checkNotNull((Object)serviceName, (String)"Service is required"), (String)Preconditions.checkNotNull((Object)host, (String)"Host is required"), port);
    }

    static Channel create(Config cf, Channel channel, String uri) {
        Optional hostEventsSink = cf.clientConf().hostEventsSink();
        if (!hostEventsSink.isPresent()) {
            return channel;
        }
        if (((HostEventsSink)hostEventsSink.get()).getClass().getSimpleName().equals("NoOpHostEventsSink")) {
            return channel;
        }
        try {
            URL parsed = new URL(uri);
            String host = parsed.getHost();
            int port = parsed.getPort() != -1 ? parsed.getPort() : parsed.getDefaultPort();
            return new HostMetricsChannel(channel, (HostEventsSink)hostEventsSink.get(), cf.ticker(), cf.channelName(), host, port);
        }
        catch (MalformedURLException e) {
            throw new SafeIllegalArgumentException("Failed to parse URI", new Arg[]{UnsafeArg.of((String)"uri", (Object)uri)});
        }
    }

    public ListenableFuture<Response> execute(Endpoint endpoint, Request request) {
        ListenableFuture result = this.delegate.execute(endpoint, request);
        DialogueFutures.addDirectCallback((ListenableFuture)result, (FutureCallback)new Callback());
        return result;
    }

    public String toString() {
        return "HostMetricsChannel{delegate=" + String.valueOf(this.delegate) + ", hostEventCallback=" + String.valueOf(this.hostEventCallback) + "}";
    }

    private final class Callback
    implements FutureCallback<Response> {
        private final long startNanos;

        private Callback() {
            this.startNanos = HostMetricsChannel.this.clock.read();
        }

        public void onSuccess(@Nullable Response result) {
            if (result != null) {
                HostMetricsChannel.this.hostEventCallback.record(result.code(), TimeUnit.NANOSECONDS.toMicros(HostMetricsChannel.this.clock.read() - this.startNanos));
            }
        }

        public void onFailure(Throwable throwable) {
            if (throwable instanceof IOException) {
                HostMetricsChannel.this.hostEventCallback.recordIoException();
            }
        }
    }
}

