/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.codahale.metrics.Meter;
import com.google.errorprone.annotations.CheckReturnValue;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class DialogueRoundrobinMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "dialogue";
    private static final String LIBRARY_VERSION = "6.8.0";
    private final TaggedMetricRegistry registry;

    private DialogueRoundrobinMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static DialogueRoundrobinMetrics of(TaggedMetricRegistry registry) {
        return new DialogueRoundrobinMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    @CheckReturnValue
    SuccessBuilderChannelNameStage success() {
        return new SuccessBuilder();
    }

    public String toString() {
        return "DialogueRoundrobinMetrics{registry=" + String.valueOf(this.registry) + "}";
    }

    private final class SuccessBuilder
    implements SuccessBuilderChannelNameStage,
    SuccessBuilderHostIndexStage,
    SuccessBuildStage {
        private String channelName;
        private String hostIndex;

        private SuccessBuilder() {
        }

        @Override
        public SuccessBuilder channelName(@Safe String channelName) {
            Preconditions.checkState((this.channelName == null ? 1 : 0) != 0, (String)"channel-name is already set");
            this.channelName = (String)Preconditions.checkNotNull((Object)channelName, (String)"channel-name is required");
            return this;
        }

        @Override
        public SuccessBuilder hostIndex(@Safe String hostIndex) {
            Preconditions.checkState((this.hostIndex == null ? 1 : 0) != 0, (String)"hostIndex is already set");
            this.hostIndex = (String)Preconditions.checkNotNull((Object)hostIndex, (String)"hostIndex is required");
            return this;
        }

        @Override
        public Meter build() {
            return DialogueRoundrobinMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.roundrobin.success").putSafeTags("channel-name", this.channelName).putSafeTags("hostIndex", this.hostIndex).putSafeTags("libraryName", DialogueRoundrobinMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueRoundrobinMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface SuccessBuilderHostIndexStage {
        @CheckReturnValue
        public SuccessBuildStage hostIndex(@Safe String var1);
    }

    static interface SuccessBuilderChannelNameStage {
        @CheckReturnValue
        public SuccessBuilderHostIndexStage channelName(@Safe String var1);
    }

    static interface SuccessBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }
}

