/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.codahale.metrics.Meter;
import com.google.errorprone.annotations.CheckReturnValue;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class DialogueNodeselectionMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "dialogue";
    private static final String LIBRARY_VERSION = "6.8.0";
    private final TaggedMetricRegistry registry;

    private DialogueNodeselectionMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static DialogueNodeselectionMetrics of(TaggedMetricRegistry registry) {
        return new DialogueNodeselectionMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    @CheckReturnValue
    StrategyBuilderChannelNameStage strategy() {
        return new StrategyBuilder();
    }

    public String toString() {
        return "DialogueNodeselectionMetrics{registry=" + String.valueOf(this.registry) + "}";
    }

    private final class StrategyBuilder
    implements StrategyBuilderChannelNameStage,
    StrategyBuilderStrategyStage,
    StrategyBuildStage {
        private String channelName;
        private String strategy;

        private StrategyBuilder() {
        }

        @Override
        public StrategyBuilder channelName(@Safe String channelName) {
            Preconditions.checkState((this.channelName == null ? 1 : 0) != 0, (String)"channel-name is already set");
            this.channelName = (String)Preconditions.checkNotNull((Object)channelName, (String)"channel-name is required");
            return this;
        }

        @Override
        public StrategyBuilder strategy(@Safe String strategy) {
            Preconditions.checkState((this.strategy == null ? 1 : 0) != 0, (String)"strategy is already set");
            this.strategy = (String)Preconditions.checkNotNull((Object)strategy, (String)"strategy is required");
            return this;
        }

        @Override
        public Meter build() {
            return DialogueNodeselectionMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.nodeselection.strategy").putSafeTags("channel-name", this.channelName).putSafeTags("strategy", this.strategy).putSafeTags("libraryName", DialogueNodeselectionMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueNodeselectionMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface StrategyBuilderStrategyStage {
        @CheckReturnValue
        public StrategyBuildStage strategy(@Safe String var1);
    }

    static interface StrategyBuilderChannelNameStage {
        @CheckReturnValue
        public StrategyBuilderStrategyStage channelName(@Safe String var1);
    }

    static interface StrategyBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }
}

