/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.codahale.metrics.Gauge;
import com.google.common.annotations.VisibleForTesting;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DialogueInternalWeakReducingGauge<T>
implements Gauge<Number> {
    @GuardedBy(value="this")
    private final Set<T> weakSet = Collections.newSetFromMap(new WeakHashMap(2));
    private final Function<Set<T>, Number> function;

    @VisibleForTesting
    DialogueInternalWeakReducingGauge(ToLongFunction<T> gaugeFunction, Function<LongStream, Number> reduceFunction) {
        this(new LongGaugeProcessor<T>(gaugeFunction, reduceFunction));
    }

    @VisibleForTesting
    DialogueInternalWeakReducingGauge(Function<Set<T>, Number> function) {
        this.function = function;
    }

    public synchronized void add(T sourceElement) {
        this.weakSet.add(sourceElement);
    }

    public synchronized Number getValue() {
        return this.function.apply(this.weakSet);
    }

    public static <T> DialogueInternalWeakReducingGauge<T> getOrCreate(TaggedMetricRegistry taggedMetricRegistry, MetricName metricName, ToLongFunction<T> toLongFunc, Function<LongStream, Number> reducingFunction, T initialObject) {
        DialogueInternalWeakReducingGauge gauge = (DialogueInternalWeakReducingGauge)taggedMetricRegistry.gauge(metricName, new DialogueInternalWeakReducingGauge<T>(new LongGaugeProcessor<T>(toLongFunc, reducingFunction)));
        gauge.add(initialObject);
        return gauge;
    }

    public static <T> DialogueInternalWeakReducingGauge<T> getOrCreateDouble(TaggedMetricRegistry taggedMetricRegistry, MetricName metricName, ToDoubleFunction<T> toLongFunc, Function<DoubleStream, Number> reducingFunction, T initialObject) {
        DialogueInternalWeakReducingGauge gauge = (DialogueInternalWeakReducingGauge)taggedMetricRegistry.gauge(metricName, new DialogueInternalWeakReducingGauge<T>(new DoubleGaugeProcessor<T>(toLongFunc, reducingFunction)));
        gauge.add(initialObject);
        return gauge;
    }

    private static final class LongGaugeProcessor<T>
    implements Function<Set<T>, Number> {
        private final ToLongFunction<T> function;
        private final Function<LongStream, Number> operator;

        LongGaugeProcessor(ToLongFunction<T> function, Function<LongStream, Number> operator) {
            this.function = function;
            this.operator = operator;
        }

        @Override
        public Number apply(Set<T> values) {
            return this.operator.apply(values.stream().mapToLong(this.function));
        }
    }

    private static final class DoubleGaugeProcessor<T>
    implements Function<Set<T>, Number> {
        private final ToDoubleFunction<T> function;
        private final Function<DoubleStream, Number> operator;

        DoubleGaugeProcessor(ToDoubleFunction<T> function, Function<DoubleStream, Number> operator) {
            this.function = function;
            this.operator = operator;
        }

        @Override
        public Number apply(Set<T> values) {
            return this.operator.apply(values.stream().mapToDouble(this.function));
        }
    }
}

