/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class DialogueExecutors {
    private static final Duration DEFAULT_KEEP_ALIVE = Duration.ofSeconds(10L);

    public static ScheduledExecutorService newSharedSingleThreadScheduler(ThreadFactory threadFactory) {
        return DialogueExecutors.newSharedSingleThreadScheduler(threadFactory, DEFAULT_KEEP_ALIVE);
    }

    @VisibleForTesting
    static ScheduledExecutorService newSharedSingleThreadScheduler(ThreadFactory threadFactory, Duration keepAliveTime) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, threadFactory);
        executor.allowCoreThreadTimeOut(true);
        executor.setKeepAliveTime(keepAliveTime.toNanos(), TimeUnit.NANOSECONDS);
        executor.setRemoveOnCancelPolicy(true);
        return executor;
    }

    private DialogueExecutors() {
    }
}

