/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.errorprone.annotations.CheckReturnValue;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class DialogueClientMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "dialogue";
    private static final String LIBRARY_VERSION = "6.8.0";
    private final TaggedMetricRegistry registry;

    private DialogueClientMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static DialogueClientMetrics of(TaggedMetricRegistry registry) {
        return new DialogueClientMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    @CheckReturnValue
    ResponseLeakBuilderClientNameStage responseLeak() {
        return new ResponseLeakBuilder();
    }

    @CheckReturnValue
    RequestRetryBuilderChannelNameStage requestRetry() {
        return new RequestRetryBuilder();
    }

    @CheckReturnValue
    Counter requestsQueued(@Safe String channelName) {
        return this.registry.counter(DialogueClientMetrics.requestsQueuedMetricName(channelName));
    }

    static MetricName requestsQueuedMetricName(@Safe String channelName) {
        return MetricName.builder().safeName("dialogue.client.requests.queued").putSafeTags("channel-name", channelName).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    @CheckReturnValue
    RequestsEndpointQueuedBuilderChannelNameStage requestsEndpointQueued() {
        return new RequestsEndpointQueuedBuilder();
    }

    @CheckReturnValue
    Counter requestsStickyQueued(@Safe String channelName) {
        return this.registry.counter(DialogueClientMetrics.requestsStickyQueuedMetricName(channelName));
    }

    static MetricName requestsStickyQueuedMetricName(@Safe String channelName) {
        return MetricName.builder().safeName("dialogue.client.requests.sticky.queued").putSafeTags("channel-name", channelName).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    @CheckReturnValue
    Timer requestQueuedTime(@Safe String channelName) {
        return this.registry.timer(DialogueClientMetrics.requestQueuedTimeMetricName(channelName));
    }

    static MetricName requestQueuedTimeMetricName(@Safe String channelName) {
        return MetricName.builder().safeName("dialogue.client.request.queued.time").putSafeTags("channel-name", channelName).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    @CheckReturnValue
    RequestEndpointQueuedTimeBuilderChannelNameStage requestEndpointQueuedTime() {
        return new RequestEndpointQueuedTimeBuilder();
    }

    @CheckReturnValue
    Timer requestStickyQueuedTime(@Safe String channelName) {
        return this.registry.timer(DialogueClientMetrics.requestStickyQueuedTimeMetricName(channelName));
    }

    static MetricName requestStickyQueuedTimeMetricName(@Safe String channelName) {
        return MetricName.builder().safeName("dialogue.client.request.sticky.queued.time").putSafeTags("channel-name", channelName).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    @CheckReturnValue
    CreateBuilderClientNameStage create() {
        return new CreateBuilder();
    }

    @CheckReturnValue
    ReloadBuilderClientNameStage reload() {
        return new ReloadBuilder();
    }

    public String toString() {
        return "DialogueClientMetrics{registry=" + String.valueOf(this.registry) + "}";
    }

    private final class ResponseLeakBuilder
    implements ResponseLeakBuilderClientNameStage,
    ResponseLeakBuilderServiceNameStage,
    ResponseLeakBuilderEndpointStage,
    ResponseLeakBuildStage {
        private String clientName;
        private String serviceName;
        private String endpoint;

        private ResponseLeakBuilder() {
        }

        @Override
        public ResponseLeakBuilder clientName(@Safe String clientName) {
            Preconditions.checkState((this.clientName == null ? 1 : 0) != 0, (String)"client-name is already set");
            this.clientName = (String)Preconditions.checkNotNull((Object)clientName, (String)"client-name is required");
            return this;
        }

        @Override
        public ResponseLeakBuilder serviceName(@Safe String serviceName) {
            Preconditions.checkState((this.serviceName == null ? 1 : 0) != 0, (String)"service-name is already set");
            this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (String)"service-name is required");
            return this;
        }

        @Override
        public ResponseLeakBuilder endpoint(@Safe String endpoint) {
            Preconditions.checkState((this.endpoint == null ? 1 : 0) != 0, (String)"endpoint is already set");
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (String)"endpoint is required");
            return this;
        }

        @Override
        public Meter build() {
            return DialogueClientMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.client.response.leak").putSafeTags("client-name", this.clientName).putSafeTags("service-name", this.serviceName).putSafeTags("endpoint", this.endpoint).putSafeTags("libraryName", DialogueClientMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueClientMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    private final class RequestRetryBuilder
    implements RequestRetryBuilderChannelNameStage,
    RequestRetryBuilderReasonStage,
    RequestRetryBuildStage {
        private String channelName;
        private String reason;

        private RequestRetryBuilder() {
        }

        @Override
        public RequestRetryBuilder channelName(@Safe String channelName) {
            Preconditions.checkState((this.channelName == null ? 1 : 0) != 0, (String)"channel-name is already set");
            this.channelName = (String)Preconditions.checkNotNull((Object)channelName, (String)"channel-name is required");
            return this;
        }

        @Override
        public RequestRetryBuilder reason(@Safe String reason) {
            Preconditions.checkState((this.reason == null ? 1 : 0) != 0, (String)"reason is already set");
            this.reason = (String)Preconditions.checkNotNull((Object)reason, (String)"reason is required");
            return this;
        }

        @Override
        public Meter build() {
            return DialogueClientMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.client.request.retry").putSafeTags("channel-name", this.channelName).putSafeTags("reason", this.reason).putSafeTags("libraryName", DialogueClientMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueClientMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    private final class RequestsEndpointQueuedBuilder
    implements RequestsEndpointQueuedBuilderChannelNameStage,
    RequestsEndpointQueuedBuilderServiceNameStage,
    RequestsEndpointQueuedBuilderEndpointStage,
    RequestsEndpointQueuedBuildStage {
        private String channelName;
        private String serviceName;
        private String endpoint;

        private RequestsEndpointQueuedBuilder() {
        }

        @Override
        public RequestsEndpointQueuedBuilder channelName(@Safe String channelName) {
            Preconditions.checkState((this.channelName == null ? 1 : 0) != 0, (String)"channel-name is already set");
            this.channelName = (String)Preconditions.checkNotNull((Object)channelName, (String)"channel-name is required");
            return this;
        }

        @Override
        public RequestsEndpointQueuedBuilder serviceName(@Safe String serviceName) {
            Preconditions.checkState((this.serviceName == null ? 1 : 0) != 0, (String)"service-name is already set");
            this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (String)"service-name is required");
            return this;
        }

        @Override
        public RequestsEndpointQueuedBuilder endpoint(@Safe String endpoint) {
            Preconditions.checkState((this.endpoint == null ? 1 : 0) != 0, (String)"endpoint is already set");
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (String)"endpoint is required");
            return this;
        }

        @Override
        public Counter build() {
            return DialogueClientMetrics.this.registry.counter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.client.requests.endpoint.queued").putSafeTags("channel-name", this.channelName).putSafeTags("service-name", this.serviceName).putSafeTags("endpoint", this.endpoint).putSafeTags("libraryName", DialogueClientMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueClientMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    private final class RequestEndpointQueuedTimeBuilder
    implements RequestEndpointQueuedTimeBuilderChannelNameStage,
    RequestEndpointQueuedTimeBuilderServiceNameStage,
    RequestEndpointQueuedTimeBuilderEndpointStage,
    RequestEndpointQueuedTimeBuildStage {
        private String channelName;
        private String serviceName;
        private String endpoint;

        private RequestEndpointQueuedTimeBuilder() {
        }

        @Override
        public RequestEndpointQueuedTimeBuilder channelName(@Safe String channelName) {
            Preconditions.checkState((this.channelName == null ? 1 : 0) != 0, (String)"channel-name is already set");
            this.channelName = (String)Preconditions.checkNotNull((Object)channelName, (String)"channel-name is required");
            return this;
        }

        @Override
        public RequestEndpointQueuedTimeBuilder serviceName(@Safe String serviceName) {
            Preconditions.checkState((this.serviceName == null ? 1 : 0) != 0, (String)"service-name is already set");
            this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (String)"service-name is required");
            return this;
        }

        @Override
        public RequestEndpointQueuedTimeBuilder endpoint(@Safe String endpoint) {
            Preconditions.checkState((this.endpoint == null ? 1 : 0) != 0, (String)"endpoint is already set");
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (String)"endpoint is required");
            return this;
        }

        @Override
        public Timer build() {
            return DialogueClientMetrics.this.registry.timer(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.client.request.endpoint.queued.time").putSafeTags("channel-name", this.channelName).putSafeTags("service-name", this.serviceName).putSafeTags("endpoint", this.endpoint).putSafeTags("libraryName", DialogueClientMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueClientMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    private final class CreateBuilder
    implements CreateBuilderClientNameStage,
    CreateBuilderClientTypeStage,
    CreateBuildStage {
        private String clientName;
        private String clientType;

        private CreateBuilder() {
        }

        @Override
        public CreateBuilder clientName(@Safe String clientName) {
            Preconditions.checkState((this.clientName == null ? 1 : 0) != 0, (String)"client-name is already set");
            this.clientName = (String)Preconditions.checkNotNull((Object)clientName, (String)"client-name is required");
            return this;
        }

        @Override
        public CreateBuilder clientType(@Safe String clientType) {
            Preconditions.checkState((this.clientType == null ? 1 : 0) != 0, (String)"client-type is already set");
            this.clientType = (String)Preconditions.checkNotNull((Object)clientType, (String)"client-type is required");
            return this;
        }

        @Override
        public Meter build() {
            return DialogueClientMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.client.create").putSafeTags("client-name", this.clientName).putSafeTags("client-type", this.clientType).putSafeTags("libraryName", DialogueClientMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueClientMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    private final class ReloadBuilder
    implements ReloadBuilderClientNameStage,
    ReloadBuilderClientTypeStage,
    ReloadBuildStage {
        private String clientName;
        private String clientType;

        private ReloadBuilder() {
        }

        @Override
        public ReloadBuilder clientName(@Safe String clientName) {
            Preconditions.checkState((this.clientName == null ? 1 : 0) != 0, (String)"client-name is already set");
            this.clientName = (String)Preconditions.checkNotNull((Object)clientName, (String)"client-name is required");
            return this;
        }

        @Override
        public ReloadBuilder clientType(@Safe String clientType) {
            Preconditions.checkState((this.clientType == null ? 1 : 0) != 0, (String)"client-type is already set");
            this.clientType = (String)Preconditions.checkNotNull((Object)clientType, (String)"client-type is required");
            return this;
        }

        @Override
        public Meter build() {
            return DialogueClientMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.client.reload").putSafeTags("client-name", this.clientName).putSafeTags("client-type", this.clientType).putSafeTags("libraryName", DialogueClientMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueClientMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface ReloadBuilderClientTypeStage {
        @CheckReturnValue
        public ReloadBuildStage clientType(@Safe String var1);
    }

    static interface ReloadBuilderClientNameStage {
        @CheckReturnValue
        public ReloadBuilderClientTypeStage clientName(@Safe String var1);
    }

    static interface ReloadBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static interface CreateBuilderClientTypeStage {
        @CheckReturnValue
        public CreateBuildStage clientType(@Safe String var1);
    }

    static interface CreateBuilderClientNameStage {
        @CheckReturnValue
        public CreateBuilderClientTypeStage clientName(@Safe String var1);
    }

    static interface CreateBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static interface RequestEndpointQueuedTimeBuilderEndpointStage {
        @CheckReturnValue
        public RequestEndpointQueuedTimeBuildStage endpoint(@Safe String var1);
    }

    static interface RequestEndpointQueuedTimeBuilderServiceNameStage {
        @CheckReturnValue
        public RequestEndpointQueuedTimeBuilderEndpointStage serviceName(@Safe String var1);
    }

    static interface RequestEndpointQueuedTimeBuilderChannelNameStage {
        @CheckReturnValue
        public RequestEndpointQueuedTimeBuilderServiceNameStage channelName(@Safe String var1);
    }

    static interface RequestEndpointQueuedTimeBuildStage {
        @CheckReturnValue
        public Timer build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static interface RequestsEndpointQueuedBuilderEndpointStage {
        @CheckReturnValue
        public RequestsEndpointQueuedBuildStage endpoint(@Safe String var1);
    }

    static interface RequestsEndpointQueuedBuilderServiceNameStage {
        @CheckReturnValue
        public RequestsEndpointQueuedBuilderEndpointStage serviceName(@Safe String var1);
    }

    static interface RequestsEndpointQueuedBuilderChannelNameStage {
        @CheckReturnValue
        public RequestsEndpointQueuedBuilderServiceNameStage channelName(@Safe String var1);
    }

    static interface RequestsEndpointQueuedBuildStage {
        @CheckReturnValue
        public Counter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static interface RequestRetryBuilderReasonStage {
        @CheckReturnValue
        public RequestRetryBuildStage reason(@Safe String var1);
    }

    static interface RequestRetryBuilderChannelNameStage {
        @CheckReturnValue
        public RequestRetryBuilderReasonStage channelName(@Safe String var1);
    }

    static interface RequestRetryBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static interface ResponseLeakBuilderEndpointStage {
        @CheckReturnValue
        public ResponseLeakBuildStage endpoint(@Safe String var1);
    }

    static interface ResponseLeakBuilderServiceNameStage {
        @CheckReturnValue
        public ResponseLeakBuilderEndpointStage serviceName(@Safe String var1);
    }

    static interface ResponseLeakBuilderClientNameStage {
        @CheckReturnValue
        public ResponseLeakBuilderServiceNameStage clientName(@Safe String var1);
    }

    static interface ResponseLeakBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }
}

