/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.codahale.metrics.Meter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Ticker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.CheckReturnValue;
import com.palantir.conjure.java.client.config.ClientConfiguration;
import com.palantir.dialogue.Channel;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.EndpointChannel;
import com.palantir.dialogue.EndpointChannelFactory;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.core.ChannelFactory;
import com.palantir.dialogue.core.ChannelState;
import com.palantir.dialogue.core.ChannelToEndpointChannel;
import com.palantir.dialogue.core.ChannelToLimitedChannelAdapter;
import com.palantir.dialogue.core.ConcurrencyLimitedChannel;
import com.palantir.dialogue.core.Config;
import com.palantir.dialogue.core.ContentDecodingChannel;
import com.palantir.dialogue.core.ContentEncodingChannel;
import com.palantir.dialogue.core.DeadlineAdvertisementChannel;
import com.palantir.dialogue.core.DeprecationWarningChannel;
import com.palantir.dialogue.core.DialogueChannelFactory;
import com.palantir.dialogue.core.DialogueClientMetrics;
import com.palantir.dialogue.core.DialogueTracing;
import com.palantir.dialogue.core.EndpointChannelAdapter;
import com.palantir.dialogue.core.HostMetricsChannel;
import com.palantir.dialogue.core.ImmutableConfig;
import com.palantir.dialogue.core.InterruptionChannel;
import com.palantir.dialogue.core.LimitedChannel;
import com.palantir.dialogue.core.NeverThrowEndpointChannel;
import com.palantir.dialogue.core.NodeSelectionStrategyChannel;
import com.palantir.dialogue.core.QueueOverrideChannel;
import com.palantir.dialogue.core.QueuedChannel;
import com.palantir.dialogue.core.RangeAcceptsIdentityEncodingChannel;
import com.palantir.dialogue.core.RequestBodyValidationChannel;
import com.palantir.dialogue.core.RetryAdvertisementChannel;
import com.palantir.dialogue.core.RetryOtherValidatingChannel;
import com.palantir.dialogue.core.RetryingChannel;
import com.palantir.dialogue.core.StickyEndpointChannels2;
import com.palantir.dialogue.core.StickyValidationChannel;
import com.palantir.dialogue.core.SupplierChannel;
import com.palantir.dialogue.core.TargetUri;
import com.palantir.dialogue.core.TimingEndpointChannel;
import com.palantir.dialogue.core.TraceEnrichingChannel;
import com.palantir.dialogue.core.TracedChannel;
import com.palantir.dialogue.core.UserAgentEndpointChannel;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import com.palantir.refreshable.Refreshable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;

public final class DialogueChannel
implements Channel,
EndpointChannelFactory {
    private static final SafeLogger log = SafeLoggerFactory.get(DialogueChannel.class);
    private final EndpointChannelFactory delegate;
    private final Config cf;
    private final Supplier<Channel> stickyChannelSupplier;

    private DialogueChannel(Config cf, EndpointChannelFactory delegate, Supplier<Channel> stickyChannelSupplier) {
        this.cf = cf;
        this.delegate = delegate;
        this.stickyChannelSupplier = stickyChannelSupplier;
    }

    public ListenableFuture<Response> execute(Endpoint endpoint, Request request) {
        return this.delegate.endpoint(endpoint).execute(request);
    }

    public EndpointChannel endpoint(Endpoint endpoint) {
        return this.delegate.endpoint(endpoint);
    }

    public Supplier<Channel> stickyChannels() {
        return this.stickyChannelSupplier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "DialogueChannel@" + Integer.toHexString(System.identityHashCode(this)) + "{channelName=" + this.cf.channelName() + ", delegate=" + String.valueOf(this.delegate) + "}";
    }

    public static final class Builder {
        private final ImmutableConfig.Builder builder = ImmutableConfig.builder();

        private Builder() {
        }

        public Builder channelName(@Safe String channelName) {
            this.builder.channelName(channelName);
            return this;
        }

        public Builder clientConfiguration(ClientConfiguration value) {
            this.builder.rawConfig(value);
            return this;
        }

        @Deprecated
        public Builder uris(List<TargetUri> value) {
            return this.uris((Refreshable<List<TargetUri>>)Refreshable.only(value));
        }

        public Builder uris(Refreshable<List<TargetUri>> value) {
            this.builder.uris(value);
            return this;
        }

        @Deprecated
        public Builder channelFactory(ChannelFactory value) {
            return this.factory(DialogueChannelFactory.from(value));
        }

        public Builder factory(DialogueChannelFactory value) {
            this.builder.channelFactory(value);
            return this;
        }

        public Builder overrideHostIndex(OptionalInt maybeUriIndex) {
            this.builder.overrideSingleHostIndex(maybeUriIndex);
            return this;
        }

        @VisibleForTesting
        Builder random(Random value) {
            this.builder.random(value);
            return this;
        }

        @VisibleForTesting
        Builder scheduler(ScheduledExecutorService value) {
            this.builder.scheduler(value);
            return this;
        }

        @VisibleForTesting
        Builder maxQueueSize(int value) {
            this.builder.maxQueueSize(value);
            return this;
        }

        @VisibleForTesting
        Builder ticker(Ticker value) {
            this.builder.ticker(value);
            return this;
        }

        @CheckReturnValue
        public DialogueChannel build() {
            final ImmutableConfig cf = this.builder.build();
            DialogueClientMetrics clientMetrics = DialogueClientMetrics.of(cf.clientConf().taggedMetricRegistry());
            final Meter reloadMeter = clientMetrics.reload().clientName(cf.channelName()).clientType("dialogue-channel-non-reloading").build();
            SupplierChannel nodeSelectionChannel = new SupplierChannel((Supplier<LimitedChannel>)cf.uris().map((Function)new Function<List<TargetUri>, LimitedChannel>(){
                private final Map<TargetUri, ChannelState> state = new ConcurrentHashMap<TargetUri, ChannelState>();

                @Override
                public LimitedChannel apply(List<TargetUri> targetUris) {
                    this.state.keySet().retainAll(targetUris);
                    targetUris.forEach(uri -> this.state.computeIfAbsent((TargetUri)uri, _uri -> new ChannelState()));
                    reloadMeter.mark();
                    log.info("Reloaded channel '{}' targets. (uris: {}, numUris: {}, targets: {}, numTargets: {})", (Arg)SafeArg.of((String)"channel", (Object)cf.channelName()), (Arg)UnsafeArg.of((String)"uris", (Object)cf.clientConf().uris()), (Arg)SafeArg.of((String)"numUris", (Object)cf.clientConf().uris().size()), (Arg)UnsafeArg.of((String)"targets", targetUris), (Arg)SafeArg.of((String)"numTargets", (Object)targetUris.size()));
                    ImmutableList<LimitedChannel> targetChannels = Builder.createHostChannels(cf, targetUris, Collections.unmodifiableMap(this.state));
                    return NodeSelectionStrategyChannel.create(cf, targetChannels);
                }
            }));
            StickyValidationChannel stickyValidationChannel = new StickyValidationChannel(nodeSelectionChannel);
            QueuedChannel multiHostQueuedChannel = QueuedChannel.create(cf, stickyValidationChannel);
            EndpointChannelFactory channelFactory = Builder.createEndpointChannelFactory(multiHostQueuedChannel, cf);
            Supplier<Channel> stickyChannelSupplier = StickyEndpointChannels2.create(cf, stickyValidationChannel, channelFactory);
            Meter createMeter = clientMetrics.create().clientName(cf.channelName()).clientType("dialogue-channel-non-reloading").build();
            createMeter.mark();
            return new DialogueChannel(cf, channelFactory, stickyChannelSupplier);
        }

        private static ImmutableList<LimitedChannel> createHostChannels(Config cf, List<TargetUri> targetUris, Map<TargetUri, ChannelState> state) {
            ImmutableList.Builder perUriChannels = ImmutableList.builder();
            for (int uriIndex = 0; uriIndex < targetUris.size(); ++uriIndex) {
                LimitedChannel limitedChannel;
                int uriIndexForInstrumentation = cf.overrideSingleHostIndex().orElse(uriIndex);
                TargetUri targetUri = targetUris.get(uriIndex);
                Channel channel = cf.channelFactory().create(DialogueChannelFactory.ChannelArgs.builder().uri(targetUri.uri()).uriIndexForInstrumentation(uriIndexForInstrumentation).resolvedAddress(targetUri.resolvedAddress()).build());
                channel = RetryOtherValidatingChannel.create(cf, channel);
                channel = HostMetricsChannel.create(cf, channel, targetUri.uri());
                channel = new TraceEnrichingChannel(channel, DialogueTracing.tracingTags(cf, uriIndexForInstrumentation));
                channel = new DeadlineAdvertisementChannel(channel, cf.clientConf().readTimeout());
                ChannelState channelState = state.get(targetUri);
                Preconditions.checkNotNull((Object)channelState, (String)"no ChannelState exists for this TargetUri");
                if (cf.isConcurrencyLimitingEnabled()) {
                    Channel unlimited = channel;
                    EndpointChannelState endpointChannelState = channelState.getState(EndpointChannelState.KEY);
                    channel = new ChannelToEndpointChannel(endpoint -> {
                        if (endpoint.tags().contains("dialogue-disable-endpoint-concurrency-limiting")) {
                            return unlimited;
                        }
                        LimitedChannel limited = ConcurrencyLimitedChannel.createForEndpoint(unlimited, cf.channelName(), uriIndexForInstrumentation, endpoint, endpointChannelState.get((Endpoint)endpoint));
                        return QueuedChannel.create(cf, endpoint, limited);
                    });
                    limitedChannel = ConcurrencyLimitedChannel.createForHost(cf, channel, uriIndexForInstrumentation, channelState);
                } else {
                    limitedChannel = new ChannelToLimitedChannelAdapter(channel);
                }
                perUriChannels.add((Object)limitedChannel);
            }
            return perUriChannels.build();
        }

        private static EndpointChannelFactory createEndpointChannelFactory(Channel multiHostQueuedChannel, Config cf) {
            QueueOverrideChannel queuedChannel = new QueueOverrideChannel(multiHostQueuedChannel);
            return endpoint -> {
                EndpointChannelAdapter endpointChannel = new EndpointChannelAdapter(endpoint, queuedChannel);
                EndpointChannel channel = cf.clientConf().userAgent().map(userAgent -> UserAgentEndpointChannel.create(endpointChannel, endpoint, userAgent)).orElse(endpointChannel);
                channel = RetryingChannel.create(cf, channel, endpoint);
                channel = DeprecationWarningChannel.create(cf, channel, endpoint);
                channel = ContentDecodingChannel.create(cf, channel, endpoint);
                channel = new RetryAdvertisementChannel(channel);
                channel = new RangeAcceptsIdentityEncodingChannel(channel);
                channel = ContentEncodingChannel.of(channel, endpoint);
                channel = TracedChannel.create(cf, channel, endpoint);
                channel = TimingEndpointChannel.create(cf, channel, endpoint);
                channel = new RequestBodyValidationChannel(channel);
                channel = new InterruptionChannel(channel);
                return new NeverThrowEndpointChannel(channel);
            };
        }

        @CheckReturnValue
        public Channel buildNonLiveReloading() {
            return this.build();
        }

        private record EndpointChannelState(LoadingCache<Endpoint, ChannelState> cache) {
            private static final ChannelState.Key<EndpointChannelState> KEY = new ChannelState.Key<EndpointChannelState>(EndpointChannelState.class, EndpointChannelState::create);

            ChannelState get(Endpoint endpoint) {
                return (ChannelState)this.cache.get((Object)endpoint);
            }

            private static EndpointChannelState create() {
                return new EndpointChannelState((LoadingCache<Endpoint, ChannelState>)Caffeine.newBuilder().weakKeys().maximumSize(10000L).build(_key -> new ChannelState()));
            }
        }
    }
}

