/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.codahale.metrics.Gauge;
import com.google.errorprone.annotations.CheckReturnValue;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class DialogueBalancedMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "dialogue";
    private static final String LIBRARY_VERSION = "6.8.0";
    private final TaggedMetricRegistry registry;

    private DialogueBalancedMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static DialogueBalancedMetrics of(TaggedMetricRegistry registry) {
        return new DialogueBalancedMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    @CheckReturnValue
    ScoreBuilderChannelNameStage score() {
        return new ScoreBuilder();
    }

    public String toString() {
        return "DialogueBalancedMetrics{registry=" + String.valueOf(this.registry) + "}";
    }

    private final class ScoreBuilder
    implements ScoreBuilderChannelNameStage,
    ScoreBuilderHostIndexStage,
    ScoreBuildStage {
        private String channelName;
        private String hostIndex;

        private ScoreBuilder() {
        }

        @Override
        public ScoreBuilder channelName(@Safe String channelName) {
            Preconditions.checkState((this.channelName == null ? 1 : 0) != 0, (String)"channel-name is already set");
            this.channelName = (String)Preconditions.checkNotNull((Object)channelName, (String)"channel-name is required");
            return this;
        }

        @Override
        public ScoreBuilder hostIndex(@Safe String hostIndex) {
            Preconditions.checkState((this.hostIndex == null ? 1 : 0) != 0, (String)"hostIndex is already set");
            this.hostIndex = (String)Preconditions.checkNotNull((Object)hostIndex, (String)"hostIndex is required");
            return this;
        }

        @Override
        public void build(Gauge<? extends Number> gauge) {
            DialogueBalancedMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.balanced.score").putSafeTags("channel-name", this.channelName).putSafeTags("hostIndex", this.hostIndex).putSafeTags("libraryName", DialogueBalancedMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueBalancedMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface ScoreBuilderHostIndexStage {
        @CheckReturnValue
        public ScoreBuildStage hostIndex(@Safe String var1);
    }

    static interface ScoreBuilderChannelNameStage {
        @CheckReturnValue
        public ScoreBuilderHostIndexStage channelName(@Safe String var1);
    }

    static interface ScoreBuildStage {
        public void build(Gauge<? extends Number> var1);

        @CheckReturnValue
        public MetricName buildMetricName();
    }
}

