/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.deadlines.DeadlineExpiredException;
import com.palantir.deadlines.Deadlines;
import com.palantir.dialogue.Channel;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.Response;
import java.time.Duration;

final class DeadlineAdvertisementChannel
implements Channel {
    private final Channel delegate;
    private final Duration readTimeout;

    DeadlineAdvertisementChannel(Channel delegate, Duration readTimeout) {
        this.delegate = delegate;
        this.readTimeout = readTimeout.isNegative() || readTimeout.isZero() ? Duration.ofDays(1L) : readTimeout;
    }

    public ListenableFuture<Response> execute(Endpoint endpoint, Request request) {
        Request.Builder requestBuilder = Request.builder().from(request);
        try {
            Deadlines.encodeToRequest((Duration)this.readTimeout, (Object)requestBuilder, (Deadlines.RequestEncodingAdapter)RequestBuilderEncodingAdapter.INSTANCE);
        }
        catch (DeadlineExpiredException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        return this.delegate.execute(endpoint, requestBuilder.build());
    }

    private static enum RequestBuilderEncodingAdapter implements Deadlines.RequestEncodingAdapter<Request.Builder>
    {
        INSTANCE;


        public void setHeader(Request.Builder builder, String headerName, String headerValue) {
            builder.putHeaderParams(headerName, headerValue);
        }
    }
}

