/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.EndpointChannel;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.RequestBody;
import com.palantir.dialogue.Response;
import com.palantir.logsafe.Preconditions;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.zip.GZIPOutputStream;

final class ContentEncodingChannel
implements EndpointChannel {
    private static final String ENABLEMENT_TAG = "compress-request";
    private static final String GZIP = "gzip";
    private static final int BUFFER_SIZE = 8192;
    private final EndpointChannel delegate;

    static EndpointChannel of(EndpointChannel delegate, Endpoint endpoint) {
        if (endpoint.tags().contains(ENABLEMENT_TAG)) {
            return new ContentEncodingChannel(delegate);
        }
        return delegate;
    }

    ContentEncodingChannel(EndpointChannel delegate) {
        this.delegate = (EndpointChannel)Preconditions.checkNotNull((Object)delegate, (String)"Channel is required");
    }

    public ListenableFuture<Response> execute(Request request) {
        Request augmentedRequest = ContentEncodingChannel.wrap(request);
        return this.delegate.execute(augmentedRequest);
    }

    static Request wrap(Request request) {
        Optional body = request.body();
        if (body.isEmpty() || request.headerParams().containsKey((Object)"Content-Encoding") || request.headerParams().containsKey((Object)"Content-Length")) {
            return request;
        }
        return Request.builder().from(request).putHeaderParams("Content-Encoding", GZIP).body((RequestBody)new ContentEncodingRequestBody((RequestBody)body.get())).build();
    }

    public String toString() {
        return "ContentEncodingChannel{" + String.valueOf(this.delegate) + "}";
    }

    private static final class ContentEncodingRequestBody
    implements RequestBody {
        private final RequestBody delegate;

        ContentEncodingRequestBody(RequestBody delegate) {
            this.delegate = delegate;
        }

        public void writeTo(OutputStream output) throws IOException {
            try (BestSpeedGzipOutputStream gzipOutput = new BestSpeedGzipOutputStream(output);
                 BufferedOutputStream bufferedOutput = new BufferedOutputStream(gzipOutput, 8192);){
                this.delegate.writeTo((OutputStream)bufferedOutput);
            }
        }

        public String contentType() {
            return this.delegate.contentType();
        }

        public boolean repeatable() {
            return this.delegate.repeatable();
        }

        public OptionalLong contentLength() {
            return OptionalLong.empty();
        }

        public void close() {
            this.delegate.close();
        }

        public String toString() {
            return "ContentEncodingRequestBody{" + String.valueOf(this.delegate) + "}";
        }
    }

    private static final class BestSpeedGzipOutputStream
    extends GZIPOutputStream {
        BestSpeedGzipOutputStream(OutputStream out) throws IOException {
            super(out, 8192);
            this.def.setLevel(1);
        }

        public String toString() {
            return "BestSpeedGzipOutputStream{" + String.valueOf(this.out) + "}";
        }
    }
}

