/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.github.benmanes.caffeine.cache.Ticker;
import com.palantir.conjure.java.client.config.ClientConfiguration;
import com.palantir.dialogue.core.DialogueChannelFactory;
import com.palantir.dialogue.core.RetryingChannel;
import com.palantir.dialogue.core.TargetUri;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.DoNotLog;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.random.SafeThreadLocalRandom;
import com.palantir.refreshable.Refreshable;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import org.immutables.value.Value;

@DoNotLog
@Value.Immutable
interface Config {
    public String channelName();

    public DialogueChannelFactory channelFactory();

    public ClientConfiguration rawConfig();

    @Value.Derived
    default public ClientConfiguration clientConf() {
        return this.rawConfig();
    }

    @Value.Default
    default public Refreshable<List<TargetUri>> uris() {
        return Refreshable.only(this.rawConfig().uris().stream().map(TargetUri::of).toList());
    }

    @Value.Derived
    default public boolean isConcurrencyLimitingEnabled() {
        return this.rawConfig().clientQoS() == ClientConfiguration.ClientQoS.ENABLED;
    }

    @Value.Default
    default public Random random() {
        return SafeThreadLocalRandom.get();
    }

    @Value.Default
    default public ScheduledExecutorService scheduler() {
        return RetryingChannel.sharedScheduler.get();
    }

    @Value.Default
    default public Ticker ticker() {
        return Ticker.systemTicker();
    }

    @Value.Default
    default public int maxQueueSize() {
        return 100000;
    }

    public OptionalInt overrideSingleHostIndex();

    @Value.Check
    default public void check() {
        Preconditions.checkArgument((this.maxQueueSize() > 0 ? 1 : 0) != 0, (String)"maxQueueSize must be positive");
        Preconditions.checkArgument((boolean)this.rawConfig().userAgent().isPresent(), (String)"userAgent must be specified");
        Preconditions.checkArgument((this.rawConfig().retryOnSocketException() == ClientConfiguration.RetryOnSocketException.ENABLED ? 1 : 0) != 0, (String)"Retries on socket exceptions cannot be disabled without disabling retries entirely.");
        if (((List)this.uris().get()).size() > 1 && this.overrideSingleHostIndex().isPresent()) {
            throw new SafeIllegalArgumentException("overrideHostIndex is only permitted when there is a single uri", new Arg[]{SafeArg.of((String)"numUris", (Object)this.rawConfig().uris().size())});
        }
    }
}

