/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.dialogue.Channel;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.core.CautiousIncreaseAggressiveDecreaseConcurrencyLimiter;
import com.palantir.dialogue.core.ChannelState;
import com.palantir.dialogue.core.Config;
import com.palantir.dialogue.core.DialogueConcurrencylimiterMetrics;
import com.palantir.dialogue.core.DialogueInternalWeakReducingGauge;
import com.palantir.dialogue.core.LimitedChannel;
import com.palantir.dialogue.core.NeverThrowChannel;
import com.palantir.dialogue.futures.DialogueFutures;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.util.Optional;
import java.util.stream.LongStream;

final class ConcurrencyLimitedChannel
implements LimitedChannel {
    private static final SafeLogger log = SafeLoggerFactory.get(ConcurrencyLimitedChannel.class);
    @VisibleForTesting
    static final ChannelState.Key<CautiousIncreaseAggressiveDecreaseConcurrencyLimiter> HOST_SPECIFIC_STATE_KEY = new ChannelState.Key<CautiousIncreaseAggressiveDecreaseConcurrencyLimiter>(CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.class, () -> new CautiousIncreaseAggressiveDecreaseConcurrencyLimiter(CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.Behavior.HOST_LEVEL));
    @VisibleForTesting
    static final ChannelState.Key<CautiousIncreaseAggressiveDecreaseConcurrencyLimiter> ENDPOINT_SPECIFIC_STATE_KEY = new ChannelState.Key<CautiousIncreaseAggressiveDecreaseConcurrencyLimiter>(CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.class, () -> new CautiousIncreaseAggressiveDecreaseConcurrencyLimiter(CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.Behavior.ENDPOINT_LEVEL));
    private final NeverThrowChannel delegate;
    private final CautiousIncreaseAggressiveDecreaseConcurrencyLimiter limiter;
    private final String channelNameForLogging;

    static LimitedChannel createForHost(Config cf, Channel channel, int uriIndex, ChannelState hostSpecificState) {
        TaggedMetricRegistry metrics = cf.clientConf().taggedMetricRegistry();
        CautiousIncreaseAggressiveDecreaseConcurrencyLimiter limiter = hostSpecificState.getState(HOST_SPECIFIC_STATE_KEY);
        HostConcurrencyLimitedChannelInstrumentation instrumentation = new HostConcurrencyLimitedChannelInstrumentation(cf.channelName(), uriIndex, limiter, metrics);
        return new ConcurrencyLimitedChannel(channel, limiter, instrumentation);
    }

    static LimitedChannel createForEndpoint(Channel channel, String channelName, int uriIndex, Endpoint endpoint, ChannelState endpointChannelState) {
        return new ConcurrencyLimitedChannel(channel, endpointChannelState.getState(ENDPOINT_SPECIFIC_STATE_KEY), new EndpointConcurrencyLimitedChannelInstrumentation(channelName, uriIndex, endpoint));
    }

    ConcurrencyLimitedChannel(Channel delegate, CautiousIncreaseAggressiveDecreaseConcurrencyLimiter limiter, ConcurrencyLimitedChannelInstrumentation instrumentation) {
        this.delegate = new NeverThrowChannel(delegate);
        this.limiter = limiter;
        this.channelNameForLogging = instrumentation.channelNameForLogging();
    }

    @Override
    public Optional<ListenableFuture<Response>> maybeExecute(Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
        Optional<CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.Permit> maybePermit = this.limiter.acquire(limitEnforcement);
        if (maybePermit.isPresent()) {
            CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.Permit permit = maybePermit.get();
            this.logPermitAcquired();
            ListenableFuture<Response> result = this.delegate.execute(endpoint, request);
            DialogueFutures.addDirectCallback(result, (FutureCallback)permit);
            return Optional.of(result);
        }
        this.logPermitRefused();
        return Optional.empty();
    }

    private void logPermitAcquired() {
        if (log.isDebugEnabled()) {
            log.debug("Sending {}/{} on {}", (Arg)SafeArg.of((String)"inflight", (Object)this.limiter.getInflight()), (Arg)SafeArg.of((String)"max", (Object)this.limiter.getLimit()), (Arg)SafeArg.of((String)"channel", (Object)this.channelNameForLogging));
        }
    }

    private void logPermitRefused() {
        if (log.isDebugEnabled()) {
            log.debug("Limited {} on {}", (Arg)SafeArg.of((String)"max", (Object)this.limiter.getLimit()), (Arg)SafeArg.of((String)"channel", (Object)this.channelNameForLogging));
        }
    }

    public String toString() {
        return "ConcurrencyLimitedChannel{delegate=" + String.valueOf(this.delegate) + ", name=" + this.channelNameForLogging + "}";
    }

    static final class HostConcurrencyLimitedChannelInstrumentation
    implements ConcurrencyLimitedChannelInstrumentation {
        private final String channelNameForLogging;

        HostConcurrencyLimitedChannelInstrumentation(String channelName, int uriIndex, CautiousIncreaseAggressiveDecreaseConcurrencyLimiter limiter, TaggedMetricRegistry taggedMetrics) {
            if (uriIndex == -1) {
                throw new SafeIllegalArgumentException("uriIndex must be specified", new Arg[]{SafeArg.of((String)"channel-name", (Object)channelName)});
            }
            this.channelNameForLogging = channelName + "{uriIndex=" + uriIndex + "}";
            DialogueConcurrencylimiterMetrics metrics = DialogueConcurrencylimiterMetrics.of(taggedMetrics);
            DialogueInternalWeakReducingGauge.getOrCreateDouble(taggedMetrics, metrics.max().channelName(channelName).hostIndex(Integer.toString(uriIndex)).buildMetricName(), CautiousIncreaseAggressiveDecreaseConcurrencyLimiter::getLimit, doubleStream -> doubleStream.min().orElse(0.0), limiter);
            DialogueInternalWeakReducingGauge.getOrCreate(taggedMetrics, metrics.inFlight().channelName(channelName).hostIndex(Integer.toString(uriIndex)).buildMetricName(), CautiousIncreaseAggressiveDecreaseConcurrencyLimiter::getInflight, LongStream::sum, limiter);
        }

        @Override
        public String channelNameForLogging() {
            return this.channelNameForLogging;
        }
    }

    static interface ConcurrencyLimitedChannelInstrumentation {
        public String channelNameForLogging();
    }

    static final class EndpointConcurrencyLimitedChannelInstrumentation
    implements ConcurrencyLimitedChannelInstrumentation {
        private final String channelNameForLogging;

        EndpointConcurrencyLimitedChannelInstrumentation(String channelName, int uriIndex, Endpoint endpoint) {
            this.channelNameForLogging = channelName + "{uriIndex=" + uriIndex + ", endpoint=" + endpoint.serviceName() + "." + endpoint.endpointName() + "}";
        }

        @Override
        public String channelNameForLogging() {
            return this.channelNameForLogging;
        }
    }
}

