/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.util.concurrent.AtomicDouble;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;

final class CoarseExponentialDecayReservoir {
    private static final int DECAYS_PER_HALF_LIFE = 10;
    private static final double DECAY_FACTOR = Math.pow(0.5, 0.1);
    private final AtomicDouble value = new AtomicDouble();
    private final AtomicLong lastDecay = new AtomicLong();
    private final LongSupplier nanoClock;
    private final long decayIntervalNanoseconds;

    CoarseExponentialDecayReservoir(LongSupplier nanoClock, Duration halfLife) {
        this.nanoClock = nanoClock;
        this.decayIntervalNanoseconds = halfLife.toNanos() / 10L;
        this.lastDecay.set(nanoClock.getAsLong());
    }

    void update(double updates) {
        this.decayIfNecessary();
        this.value.addAndGet(updates);
    }

    double get() {
        this.decayIfNecessary();
        return this.value.get();
    }

    private void decayIfNecessary() {
        long lastDecaySnapshot;
        long now = this.nanoClock.getAsLong();
        long nanosSinceLastDecay = now - (lastDecaySnapshot = this.lastDecay.get());
        int decays = (int)(nanosSinceLastDecay / this.decayIntervalNanoseconds);
        if (decays > 0 && this.lastDecay.compareAndSet(lastDecaySnapshot, lastDecaySnapshot + (long)decays * this.decayIntervalNanoseconds)) {
            this.decay(decays);
        }
    }

    private void decay(int decayIterations) {
        double updated;
        double snapshot;
        AtomicDouble valueAtomicDouble = this.value;
        while (!valueAtomicDouble.compareAndSet(snapshot = valueAtomicDouble.get(), updated = snapshot * Math.pow(DECAY_FACTOR, decayIterations))) {
        }
    }

    public String toString() {
        return "CoarseExponentialDecay{value=" + String.valueOf(this.value) + ", decayIntervalNanoseconds=" + this.decayIntervalNanoseconds + "}";
    }
}

