/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.AtomicDouble;
import com.google.common.util.concurrent.FutureCallback;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.core.LimitedChannel;
import com.palantir.dialogue.core.Responses;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.DoubleBinaryOperator;
import org.jspecify.annotations.Nullable;

final class CautiousIncreaseAggressiveDecreaseConcurrencyLimiter {
    private static final SafeLogger log = SafeLoggerFactory.get(CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.class);
    private static final double INITIAL_LIMIT = 20.0;
    private static final double BACKOFF_RATIO = 0.9;
    private static final double MIN_LIMIT = 1.0;
    private static final double MAX_LIMIT = 1000000.0;
    private final AtomicDouble limit = new AtomicDouble(20.0);
    private final AtomicInteger inFlight = new AtomicInteger();
    private final Behavior behavior;

    CautiousIncreaseAggressiveDecreaseConcurrencyLimiter(Behavior behavior) {
        this.behavior = behavior;
    }

    Optional<Permit> acquire(LimitedChannel.LimitEnforcement limitEnforcement) {
        int newInFlight;
        int currentInFlight;
        AtomicInteger localInFlight = this.inFlight;
        int currentLimit = (int)this.getLimit();
        do {
            currentInFlight = localInFlight.get();
            if (!limitEnforcement.enforceLimits() || currentInFlight < currentLimit) continue;
            return Optional.empty();
        } while (!this.inFlight.compareAndSet(currentInFlight, newInFlight = currentInFlight + 1));
        return Optional.of(new Permit(newInFlight));
    }

    private double accumulateAndGetLimit(int value, DoubleBinaryOperator accumulatorFunction) {
        double accumulatorResult;
        double limitSnapshot;
        AtomicDouble localLimit = this.limit;
        while (!localLimit.compareAndSet(limitSnapshot = localLimit.get(), accumulatorResult = accumulatorFunction.applyAsDouble(limitSnapshot, value))) {
        }
        return accumulatorResult;
    }

    double getLimit() {
        return this.limit.get();
    }

    int getInflight() {
        return this.inFlight.get();
    }

    public String toString() {
        return "AimdConcurrencyLimiter{limit=" + String.valueOf(this.limit) + ", inFlight=" + String.valueOf(this.inFlight) + "}";
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Behavior {
        HOST_LEVEL{

            @Override
            void onSuccess(Response result, PermitControl control) {
                if (Responses.isTooManyRequests(result) || Responses.isInternalServerError(result) || Responses.isQosDueToCustom(result)) {
                    control.ignore();
                } else if (Responses.isQosStatus(result) && !Responses.isTooManyRequests(result) || Responses.isServerErrorRange(result)) {
                    control.dropped();
                } else {
                    control.success();
                }
            }

            @Override
            void onFailure(Throwable throwable, PermitControl control) {
                if (throwable instanceof IOException) {
                    control.dropped();
                } else {
                    control.ignore();
                }
            }
        }
        ,
        ENDPOINT_LEVEL{

            @Override
            void onSuccess(Response result, PermitControl control) {
                if (Responses.isTooManyRequests(result) && !Responses.isQosDueToCustom(result) || Responses.isInternalServerError(result)) {
                    control.dropped();
                } else if (Responses.isServerErrorRange(result)) {
                    control.ignore();
                } else {
                    control.success();
                }
            }

            @Override
            void onFailure(Throwable _throwable, PermitControl control) {
                control.ignore();
            }
        }
        ,
        STICKY{

            @Override
            void onSuccess(Response _result, PermitControl control) {
                control.success();
            }

            @Override
            void onFailure(Throwable _throwable, PermitControl control) {
                control.ignore();
            }
        };


        abstract void onSuccess(Response var1, PermitControl var2);

        abstract void onFailure(Throwable var1, PermitControl var2);
    }

    final class Permit
    implements PermitControl,
    FutureCallback<Response> {
        private final int inFlightSnapshot;

        Permit(int inFlightSnapshot) {
            this.inFlightSnapshot = inFlightSnapshot;
        }

        boolean isOnlyInFlight() {
            return this.inFlightSnapshot == 1;
        }

        @VisibleForTesting
        int inFlightSnapshot() {
            return this.inFlightSnapshot;
        }

        public void onSuccess(@Nullable Response result) {
            if (result != null) {
                CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.this.behavior.onSuccess(result, this);
            }
        }

        public void onFailure(Throwable throwable) {
            CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.this.behavior.onFailure(throwable, this);
        }

        @Override
        public void ignore() {
            CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.this.inFlight.decrementAndGet();
        }

        @Override
        public void dropped() {
            CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.this.inFlight.decrementAndGet();
            double newLimit = CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.this.accumulateAndGetLimit(this.inFlightSnapshot, LimitUpdater.DROPPED);
            if (log.isDebugEnabled()) {
                log.debug("Decreasing limit {}", (Arg)SafeArg.of((String)"newLimit", (Object)newLimit));
            }
        }

        @Override
        public void success() {
            CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.this.inFlight.decrementAndGet();
            double newLimit = CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.this.accumulateAndGetLimit(this.inFlightSnapshot, LimitUpdater.SUCCESS);
            if (log.isDebugEnabled()) {
                log.debug("Increasing limit {}", (Arg)SafeArg.of((String)"newLimit", (Object)newLimit));
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum LimitUpdater implements DoubleBinaryOperator
    {
        SUCCESS{

            @Override
            public double applyAsDouble(double originalLimit, double inFlightSnapshot) {
                if (inFlightSnapshot >= Math.floor(originalLimit * 0.9)) {
                    double increment = 1.0 / originalLimit;
                    return Math.min(1000000.0, originalLimit + increment);
                }
                return originalLimit;
            }
        }
        ,
        DROPPED{

            @Override
            public double applyAsDouble(double originalLimit, double _inFlightSnapshot) {
                return Math.max(1.0, Math.floor(originalLimit * 0.9));
            }
        };

    }

    static interface PermitControl {
        public void ignore();

        public void dropped();

        public void success();
    }
}

