/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.github.benmanes.caffeine.cache.Ticker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.math.IntMath;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.core.BalancedScoreTracker;
import com.palantir.dialogue.core.LimitedChannel;
import com.palantir.dialogue.core.StickyAttachments;
import com.palantir.dialogue.futures.DialogueFutures;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.util.Optional;
import java.util.Random;
import java.util.stream.IntStream;

final class BalancedNodeSelectionStrategyChannel
implements LimitedChannel {
    private static final SafeLogger log = SafeLoggerFactory.get(BalancedNodeSelectionStrategyChannel.class);
    private static final int INFLIGHT_COMPARISON_THRESHOLD = 5;
    private static final int UNHEALTHY_SCORE_MULTIPLIER = 2;
    private final BalancedScoreTracker tracker;
    private final ImmutableList<BalancedChannel> channels;

    BalancedNodeSelectionStrategyChannel(ImmutableList<LimitedChannel> channels, Random random, Ticker ticker, TaggedMetricRegistry taggedMetrics, String channelName) {
        Preconditions.checkState((channels.size() >= 2 ? 1 : 0) != 0, (String)"At least two channels required");
        this.tracker = new BalancedScoreTracker(channels.size(), random, ticker, taggedMetrics, channelName);
        this.channels = (ImmutableList)IntStream.range(0, channels.size()).mapToObj(index -> new BalancedChannel((LimitedChannel)channels.get(index), (BalancedScoreTracker.ChannelScoreInfo)this.tracker.channelStats().get(index))).collect(ImmutableList.toImmutableList());
        log.debug("Initialized", (Arg)SafeArg.of((String)"count", (Object)channels.size()), (Arg)UnsafeArg.of((String)"channels", channels));
    }

    @Override
    public Optional<ListenableFuture<Response>> maybeExecute(Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
        BalancedScoreTracker.ScoreSnapshot[] snapshotsByScore = this.tracker.getSnapshotsInOrderOfIncreasingScore();
        int giveUpThreshold = Integer.MAX_VALUE;
        for (BalancedScoreTracker.ScoreSnapshot snapshot : snapshotsByScore) {
            BalancedChannel channel;
            Optional<ListenableFuture<Response>> maybe;
            if (snapshot.getScore() > giveUpThreshold) {
                if (log.isDebugEnabled()) {
                    log.debug("Giving up and queueing because channel score ({}) for channel {} is not worth sending a request to ({})", (Arg)SafeArg.of((String)"score", (Object)snapshot.getScore()), (Arg)SafeArg.of((String)"hostIndex", (Object)snapshot.getDelegate().channelIndex()), (Arg)SafeArg.of((String)"giveUpScore", (Object)giveUpThreshold));
                }
                return Optional.empty();
            }
            if (snapshot.getInflight() > 5) {
                int newThreshold = IntMath.saturatedMultiply((int)snapshot.getScore(), (int)2);
                if (log.isDebugEnabled()) {
                    log.debug("When considering channel {}, giveUpThreshold {} -> {}", (Arg)SafeArg.of((String)"hostIndex", (Object)snapshot.getDelegate().channelIndex()), (Arg)SafeArg.of((String)"old", (Object)giveUpThreshold), (Arg)SafeArg.of((String)"new", (Object)newThreshold));
                }
                giveUpThreshold = newThreshold;
            }
            if (!(maybe = StickyAttachments.maybeAddStickyToken(channel = (BalancedChannel)this.channels.get(snapshot.getDelegate().channelIndex()), endpoint, request, limitEnforcement)).isPresent()) continue;
            return maybe;
        }
        return Optional.empty();
    }

    @VisibleForTesting
    IntStream getScoresForTesting() {
        return this.tracker.getScoresForTesting();
    }

    public String toString() {
        return "BalancedNodeSelectionStrategyChannel{channels=" + String.valueOf(this.channels) + ", tracker=" + String.valueOf(this.tracker) + "}";
    }

    private static final class BalancedChannel
    implements LimitedChannel {
        private final LimitedChannel delegate;
        private final BalancedScoreTracker.ChannelScoreInfo channelInfo;

        BalancedChannel(LimitedChannel delegate, BalancedScoreTracker.ChannelScoreInfo channelInfo) {
            this.delegate = delegate;
            this.channelInfo = channelInfo;
        }

        @Override
        public Optional<ListenableFuture<Response>> maybeExecute(Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
            this.channelInfo.startRequest();
            Optional<ListenableFuture<Response>> maybe = this.delegate.maybeExecute(endpoint, request, limitEnforcement);
            if (maybe.isPresent()) {
                this.channelInfo.observability().markRequestMade();
                DialogueFutures.addDirectCallback(maybe.get(), (FutureCallback)this.channelInfo);
                return maybe;
            }
            this.channelInfo.undoStartRequest();
            return Optional.empty();
        }

        public String toString() {
            return "BalancedChannel{delegate=" + String.valueOf(this.delegate) + ", channelInfo=" + String.valueOf(this.channelInfo) + "}";
        }
    }
}

