/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.annotations;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.palantir.conjure.java.dialogue.serde.DefaultConjureRuntime;
import com.palantir.conjure.java.dialogue.serde.Encoding;
import com.palantir.dialogue.BodySerDe;
import com.palantir.dialogue.Deserializer;
import com.palantir.dialogue.Serializer;
import com.palantir.dialogue.TypeMarker;
import com.palantir.dialogue.annotations.BodySerDeSingleton;
import com.palantir.dialogue.annotations.DeserializerFactory;
import com.palantir.dialogue.annotations.SerializerFactory;
import com.palantir.logsafe.Preconditions;
import java.io.InputStream;
import org.jspecify.annotations.Nullable;

public final class Json
implements DeserializerFactory<Object>,
SerializerFactory<Object> {
    private final BodySerDe bodySerDe;

    public Json() {
        this(BodySerDeSingleton.DEFAULT_BODY_SERDE);
    }

    public Json(ObjectMapper mapper) {
        this(DefaultConjureRuntime.builder().encodings(Json.json(mapper)).build().bodySerDe());
    }

    private Json(BodySerDe bodySerDe) {
        this.bodySerDe = bodySerDe;
    }

    @Override
    public <T> Deserializer<T> deserializerFor(TypeMarker<T> type) {
        return this.bodySerDe.deserializer(type);
    }

    @Override
    public <T> Serializer<T> serializerFor(TypeMarker<T> type) {
        return this.bodySerDe.serializer(type);
    }

    private static Encoding json(ObjectMapper mapper) {
        return new AbstractJacksonEncoding(mapper){
            private static final String CONTENT_TYPE = "application/json";

            public String getContentType() {
                return CONTENT_TYPE;
            }

            public boolean supportsContentType(String contentType) {
                return Json.matchesContentType(CONTENT_TYPE, contentType);
            }
        };
    }

    static boolean matchesContentType(String contentType, @Nullable String typeToCheck) {
        return typeToCheck != null && typeToCheck.startsWith(contentType);
    }

    private static abstract class AbstractJacksonEncoding
    implements Encoding {
        private final ObjectMapper mapper;

        AbstractJacksonEncoding(ObjectMapper mapper) {
            this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (String)"ObjectMapper is required");
        }

        public final <T> Encoding.Serializer<T> serializer(TypeMarker<T> type) {
            ObjectWriter writer = this.mapper.writerFor(this.mapper.constructType(type.getType()));
            return (value, output) -> writer.writeValue(output, Preconditions.checkNotNull((Object)value, (String)"cannot serialize null value"));
        }

        public final <T> Encoding.Deserializer<T> deserializer(TypeMarker<T> type) {
            ObjectReader reader = this.mapper.readerFor(this.mapper.constructType(type.getType()));
            return input -> {
                try (InputStream inputStream = input;){
                    Object value = reader.readValue(inputStream);
                    Object object = Preconditions.checkNotNull((Object)value, (String)"cannot deserialize a JSON null value");
                    return object;
                }
            };
        }

        public final String toString() {
            return "AbstractJacksonEncoding{" + this.getContentType() + "}";
        }
    }
}

