/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.annotations;

import com.palantir.dialogue.annotations.ContentBody;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class InputStreamContentBody
implements ContentBody {
    private static final SafeLogger log = SafeLoggerFactory.get(InputStreamContentBody.class);
    private final String contentType;
    private final InputStream inputStream;

    InputStreamContentBody(String contentType, InputStream inputStream) {
        this.contentType = (String)Preconditions.checkNotNull((Object)contentType, (String)"contentType");
        this.inputStream = (InputStream)Preconditions.checkNotNull((Object)inputStream, (String)"inputStream");
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        this.inputStream.transferTo(output);
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public boolean repeatable() {
        return false;
    }

    @Override
    public void close() {
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            log.warn("Failed to close InputStreamContentBody {}", (Arg)UnsafeArg.of((String)"body", (Object)this.inputStream), (Throwable)e);
        }
    }
}

