/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.annotations;

import com.google.common.reflect.TypeToken;
import com.palantir.dialogue.Deserializer;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.TypeMarker;
import com.palantir.dialogue.annotations.DeserializerFactory;
import com.palantir.dialogue.annotations.ErrorDecoder;
import com.palantir.logsafe.Preconditions;
import java.io.Closeable;
import java.lang.reflect.Type;
import java.util.Optional;

public final class ErrorHandlingDeserializerFactory<T>
implements DeserializerFactory<T> {
    private final DeserializerFactory<T> delegate;
    private final ErrorDecoder errorDecoder;

    public ErrorHandlingDeserializerFactory(DeserializerFactory<T> delegate, ErrorDecoder errorDecoder) {
        this.delegate = (DeserializerFactory)Preconditions.checkNotNull(delegate, (String)"delegate");
        this.errorDecoder = (ErrorDecoder)Preconditions.checkNotNull((Object)errorDecoder, (String)"errorDecoder");
    }

    @Override
    public <T1 extends T> Deserializer<T1> deserializerFor(TypeMarker<T1> type) {
        final Deserializer<T1> delegateDeserializer = this.delegate.deserializerFor(type);
        final boolean isCloseable = TypeToken.of((Type)type.getType()).isSubtypeOf(Closeable.class);
        return new Deserializer<T1>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T1 deserialize(Response response) {
                boolean closeResponse = true;
                try {
                    if (ErrorHandlingDeserializerFactory.this.errorDecoder.isError(response)) {
                        throw ErrorHandlingDeserializerFactory.this.errorDecoder.decode(response);
                    }
                    Object toReturn = delegateDeserializer.deserialize(response);
                    closeResponse = !isCloseable;
                    Object object = toReturn;
                    return object;
                }
                finally {
                    if (closeResponse) {
                        response.close();
                    }
                }
            }

            public Optional<String> accepts() {
                return delegateDeserializer.accepts();
            }
        };
    }
}

