/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.serialization;

import com.codahale.metrics.Histogram;
import com.google.common.util.concurrent.RateLimiter;
import com.palantir.conjure.java.serialization.JsonParserMetrics;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import com.palantir.tritium.metrics.registry.SharedTaggedMetricRegistries;

final class ParserInstrumentation {
    private static final RateLimiter LOGGING_RATE_LIMITER = RateLimiter.create((double)1.0);
    private static final SafeLogger log = SafeLoggerFactory.get(ParserInstrumentation.class);
    private final Throwable creationStackTrace = new SafeRuntimeException("Stream factory created here", new Arg[0]);
    private final Histogram parsedStringLength;

    ParserInstrumentation(String format) {
        this.parsedStringLength = JsonParserMetrics.of(SharedTaggedMetricRegistries.getSingleton()).stringLength(format);
    }

    String recordStringLength(String value) {
        int length;
        if (value != null && (length = value.length()) > 524288) {
            this.recordNontrivialStringLength(length);
        }
        return value;
    }

    private void recordNontrivialStringLength(int length) {
        this.parsedStringLength.update(length);
        if (length > 4000000 && LOGGING_RATE_LIMITER.tryAcquire()) {
            log.warn("Detected an unusually large JSON string value", (Arg)SafeArg.of((String)"length", (Object)length), (Throwable)new SafeRuntimeException("Parsed here", this.creationStackTrace, new Arg[0]));
        }
    }
}

