/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.annotations;

import com.palantir.conjure.java.undertow.annotations.ParamDecoder;
import com.palantir.conjure.java.undertow.lib.Deserializer;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.PathTemplateMatch;
import java.util.Map;

public final class PathParamDeserializer<T>
implements Deserializer<T> {
    private final String pathParameterName;
    private final ParamDecoder<? extends T> decoder;

    public PathParamDeserializer(String pathParameterName, ParamDecoder<? extends T> decoder) {
        this.pathParameterName = (String)Preconditions.checkNotNull((Object)pathParameterName, (String)"Path parameter name is required");
        this.decoder = (ParamDecoder)Preconditions.checkNotNull(decoder, (String)"Decoder is required");
    }

    public T deserialize(HttpServerExchange exchange) {
        Map pathParams = ((PathTemplateMatch)exchange.getAttachment(PathTemplateMatch.ATTACHMENT_KEY)).getParameters();
        String value = (String)pathParams.get(this.pathParameterName);
        if (value == null) {
            throw new SafeIllegalStateException("Failed to find path parameter", new Arg[]{SafeArg.of((String)"pathParameter", (Object)this.pathParameterName)});
        }
        return (T)Preconditions.checkNotNull(this.decoder.decode(value), (String)"Decoder produced a null value");
    }
}

