/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.annotations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.palantir.conjure.java.lib.SafeLong;
import com.palantir.conjure.java.undertow.annotations.CollectionParamDecoder;
import com.palantir.conjure.java.undertow.annotations.ParamDecoder;
import com.palantir.conjure.java.undertow.lib.PlainSerDe;
import com.palantir.ri.ResourceIdentifier;
import com.palantir.tokens.auth.BearerToken;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;

public final class ParamDecoders {
    public static ParamDecoder<String> stringParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeString(arg_0));
    }

    public static ParamDecoder<Optional<String>> optionalStringParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeOptionalString(arg_0), Optional.empty());
    }

    public static CollectionParamDecoder<String> stringCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeString(arg_0));
    }

    public static CollectionParamDecoder<Optional<String>> optionalStringCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeOptionalString(arg_0));
    }

    public static CollectionParamDecoder<List<String>> stringListCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeStringList(arg_0));
    }

    public static CollectionParamDecoder<Set<String>> stringSetCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeStringSet(arg_0));
    }

    public static ParamDecoder<Boolean> booleanParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeBoolean(arg_0));
    }

    public static ParamDecoder<Optional<Boolean>> optionalBooleanParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeOptionalBoolean(arg_0), Optional.empty());
    }

    public static CollectionParamDecoder<Boolean> booleanCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeBoolean(arg_0));
    }

    public static CollectionParamDecoder<Optional<Boolean>> optionalBooleanCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeOptionalBoolean(arg_0));
    }

    public static CollectionParamDecoder<List<Boolean>> booleanListCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeBooleanList(arg_0));
    }

    public static CollectionParamDecoder<Set<Boolean>> booleanSetCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeBooleanSet(arg_0));
    }

    public static ParamDecoder<BearerToken> bearerTokenParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeBearerToken(arg_0));
    }

    public static ParamDecoder<Optional<BearerToken>> optionalBearerTokenParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeOptionalBearerToken(arg_0), Optional.empty());
    }

    public static CollectionParamDecoder<BearerToken> bearerTokenCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeBearerToken(arg_0));
    }

    public static CollectionParamDecoder<Optional<BearerToken>> optionalBearerTokenCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeOptionalBearerToken(arg_0));
    }

    public static CollectionParamDecoder<List<BearerToken>> bearerTokenListCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeBearerTokenList(arg_0));
    }

    public static CollectionParamDecoder<Set<BearerToken>> bearerTokenSetCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeBearerTokenSet(arg_0));
    }

    public static ParamDecoder<OffsetDateTime> dateTimeParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeDateTime(arg_0));
    }

    public static ParamDecoder<Optional<OffsetDateTime>> optionalDateTimeParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeOptionalDateTime(arg_0), Optional.empty());
    }

    public static CollectionParamDecoder<OffsetDateTime> dateTimeCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeDateTime(arg_0));
    }

    public static CollectionParamDecoder<Optional<OffsetDateTime>> optionalDateTimeCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeOptionalDateTime(arg_0));
    }

    public static CollectionParamDecoder<List<OffsetDateTime>> dateTimeListCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeDateTimeList(arg_0));
    }

    public static CollectionParamDecoder<Set<OffsetDateTime>> dateTimeSetCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeDateTimeSet(arg_0));
    }

    public static ParamDecoder<Double> doubleParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeDouble(arg_0));
    }

    public static ParamDecoder<OptionalDouble> optionalDoubleParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeOptionalDouble(arg_0), OptionalDouble.empty());
    }

    public static CollectionParamDecoder<Double> doubleCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeDouble(arg_0));
    }

    public static CollectionParamDecoder<OptionalDouble> optionalDoubleCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeOptionalDouble(arg_0));
    }

    public static CollectionParamDecoder<List<Double>> doubleListCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeDoubleList(arg_0));
    }

    public static CollectionParamDecoder<Set<Double>> doubleSetCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeDoubleSet(arg_0));
    }

    public static ParamDecoder<Integer> integerParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeInteger(arg_0));
    }

    public static ParamDecoder<OptionalInt> optionalIntegerParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeOptionalInteger(arg_0), OptionalInt.empty());
    }

    public static CollectionParamDecoder<Integer> integerCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeInteger(arg_0));
    }

    public static CollectionParamDecoder<OptionalInt> optionalIntegerCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeOptionalInteger(arg_0));
    }

    public static CollectionParamDecoder<List<Integer>> integerListCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeIntegerList(arg_0));
    }

    public static CollectionParamDecoder<Set<Integer>> integerSetCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeIntegerSet(arg_0));
    }

    public static ParamDecoder<ResourceIdentifier> ridParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeRid(arg_0));
    }

    public static ParamDecoder<Optional<ResourceIdentifier>> optionalRidParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeOptionalRid(arg_0), Optional.empty());
    }

    public static CollectionParamDecoder<ResourceIdentifier> ridCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeRid(arg_0));
    }

    public static CollectionParamDecoder<Optional<ResourceIdentifier>> optionalRidCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeOptionalRid(arg_0));
    }

    public static CollectionParamDecoder<List<ResourceIdentifier>> ridListCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeRidList(arg_0));
    }

    public static CollectionParamDecoder<Set<ResourceIdentifier>> ridSetCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeRidSet(arg_0));
    }

    public static ParamDecoder<SafeLong> safeLongParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeSafeLong(arg_0));
    }

    public static ParamDecoder<Optional<SafeLong>> optionalSafeLongParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeOptionalSafeLong(arg_0), Optional.empty());
    }

    public static CollectionParamDecoder<SafeLong> safeLongCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeSafeLong(arg_0));
    }

    public static CollectionParamDecoder<Optional<SafeLong>> optionalSafeLongCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeOptionalSafeLong(arg_0));
    }

    public static CollectionParamDecoder<List<SafeLong>> safeLongListCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeSafeLongList(arg_0));
    }

    public static CollectionParamDecoder<Set<SafeLong>> safeLongSetCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeSafeLongSet(arg_0));
    }

    public static ParamDecoder<Long> longParamDecoder(PlainSerDe serde) {
        return ParamDecoders.complexParamDecoder(serde, Long::parseLong);
    }

    public static ParamDecoder<OptionalLong> optionalLongParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(in -> OptionalLong.of((Long)serde.deserializeComplex(in, Long::parseLong)), OptionalLong.empty());
    }

    public static CollectionParamDecoder<Long> longCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(in -> (Long)serde.deserializeComplex((Iterable)in, Long::parseLong));
    }

    public static CollectionParamDecoder<OptionalLong> optionalLongCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(in -> {
            if (in == null || Iterables.isEmpty((Iterable)in)) {
                return OptionalLong.empty();
            }
            return OptionalLong.of((Long)serde.deserializeComplex((Iterable)in, Long::parseLong));
        });
    }

    public static CollectionParamDecoder<List<Long>> longListCollectionParamDecoder(PlainSerDe serde) {
        return ParamDecoders.complexListCollectionParamDecoder(serde, Long::parseLong);
    }

    public static CollectionParamDecoder<Set<Long>> longSetCollectionParamDecoder(PlainSerDe serde) {
        return ParamDecoders.complexSetCollectionParamDecoder(serde, Long::parseLong);
    }

    public static ParamDecoder<UUID> uuidParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeUuid(arg_0));
    }

    public static ParamDecoder<Optional<UUID>> optionalUuidParamDecoder(PlainSerDe serde) {
        return DelegatingParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeOptionalUuid(arg_0), Optional.empty());
    }

    public static CollectionParamDecoder<UUID> uuidCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeUuid(arg_0));
    }

    public static CollectionParamDecoder<Optional<UUID>> optionalUuidCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeOptionalUuid(arg_0));
    }

    public static CollectionParamDecoder<List<UUID>> uuidListCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeUuidList(arg_0));
    }

    public static CollectionParamDecoder<Set<UUID>> uuidSetCollectionParamDecoder(PlainSerDe serde) {
        return DelegatingCollectionParamDecoder.of(arg_0 -> ((PlainSerDe)serde).deserializeUuidSet(arg_0));
    }

    public static <T> ParamDecoder<T> complexParamDecoder(PlainSerDe serde, Function<String, T> factory) {
        return DelegatingParamDecoder.of(value -> serde.deserializeComplex(value, factory));
    }

    public static <T> ParamDecoder<Optional<T>> optionalComplexParamDecoder(PlainSerDe serde, Function<String, T> factory) {
        return DelegatingParamDecoder.of(value -> serde.deserializeOptionalComplex((Iterable)ImmutableList.of((Object)value), factory), Optional.empty());
    }

    public static <T> CollectionParamDecoder<T> complexCollectionParamDecoder(PlainSerDe serde, Function<String, T> factory) {
        return DelegatingCollectionParamDecoder.of(value -> serde.deserializeComplex((Iterable)value, factory));
    }

    public static <T> CollectionParamDecoder<Optional<T>> optionalComplexCollectionParamDecoder(PlainSerDe serde, Function<String, T> factory) {
        return DelegatingCollectionParamDecoder.of(value -> serde.deserializeOptionalComplex((Iterable)value, factory));
    }

    public static <T> CollectionParamDecoder<List<T>> complexListCollectionParamDecoder(PlainSerDe serde, Function<String, T> factory) {
        return DelegatingCollectionParamDecoder.of(value -> serde.deserializeComplexList((Iterable)value, factory));
    }

    public static <T> CollectionParamDecoder<Set<T>> complexSetCollectionParamDecoder(PlainSerDe serde, Function<String, T> factory) {
        return DelegatingCollectionParamDecoder.of(value -> serde.deserializeComplexSet((Iterable)value, factory));
    }

    private ParamDecoders() {
    }

    private static final class DelegatingParamDecoder<T>
    implements ParamDecoder<T> {
        private final Function<String, T> factory;
        private final Optional<T> noValuePresent;

        private DelegatingParamDecoder(Function<String, T> factory, Optional<T> noValuePresent) {
            this.factory = factory;
            this.noValuePresent = noValuePresent;
        }

        static <T> DelegatingParamDecoder<T> of(Function<String, T> factory) {
            return new DelegatingParamDecoder<T>(factory, Optional.empty());
        }

        static <T> DelegatingParamDecoder<T> of(Function<String, T> factory, T noValuePresent) {
            return new DelegatingParamDecoder<T>(factory, Optional.of(noValuePresent));
        }

        @Override
        public T decode(String value) {
            return this.factory.apply(value);
        }

        @Override
        public Optional<T> noValuePresent() {
            return this.noValuePresent;
        }
    }

    private static final class DelegatingCollectionParamDecoder<T>
    implements CollectionParamDecoder<T> {
        private final Function<Collection<String>, T> factory;

        private DelegatingCollectionParamDecoder(Function<Collection<String>, T> factory) {
            this.factory = factory;
        }

        static <T> DelegatingCollectionParamDecoder<T> of(Function<Collection<String>, T> factory) {
            return new DelegatingCollectionParamDecoder<T>(factory);
        }

        @Override
        public T decode(Collection<String> value) {
            return this.factory.apply(value);
        }
    }
}

