/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.palantir.conjure.java.undertow.lib.TypeMarker;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

final class TypeMarkers {
    static boolean isOptional(TypeMarker<?> marker) {
        Type type = marker.getType();
        if (OptionalDouble.class.equals((Object)type) || OptionalInt.class.equals((Object)type) || OptionalLong.class.equals((Object)type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return Optional.class.equals((Object)parameterizedType.getRawType());
        }
        return false;
    }

    static <T> T getEmptyOptional(TypeMarker<T> marker) {
        ParameterizedType parameterizedType;
        Type type = marker.getType();
        if (type instanceof ParameterizedType && Optional.class.equals((Object)(parameterizedType = (ParameterizedType)type).getRawType())) {
            return (T)Optional.empty();
        }
        if (OptionalDouble.class.equals((Object)type)) {
            return (T)OptionalDouble.empty();
        }
        if (OptionalInt.class.equals((Object)type)) {
            return (T)OptionalInt.empty();
        }
        if (OptionalLong.class.equals((Object)type)) {
            return (T)OptionalLong.empty();
        }
        throw new SafeIllegalArgumentException("Expected a TypeMarker representing an optional type", new Arg[]{SafeArg.of((String)"marker", marker)});
    }

    private TypeMarkers() {
    }
}

