/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.google.common.collect.ImmutableMap;
import com.palantir.conjure.java.undertow.lib.Endpoint;
import com.palantir.conjure.java.undertow.lib.TypeMarker;
import com.palantir.conjure.java.undertow.runtime.Encoding;
import com.palantir.tracing.Tracer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;

final class TracedEncoding
implements Encoding {
    static final String DESERIALIZE_OPERATION = "Undertow: deserialize";
    static final String SERIALIZE_OPERATION = "Undertow: serialize";
    private final Encoding encoding;

    private TracedEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    static Encoding wrap(Encoding encoding) {
        return new TracedEncoding(encoding);
    }

    @Override
    public <T> Encoding.Serializer<T> serializer(TypeMarker<T> type) {
        return new TracedSerializer<T>(this.encoding.serializer(type), SERIALIZE_OPERATION, this.getTags(type));
    }

    @Override
    public <T> Encoding.Serializer<T> serializer(TypeMarker<T> type, Endpoint endpoint) {
        return new TracedSerializer<T>(this.encoding.serializer(type, endpoint), SERIALIZE_OPERATION, this.getTags(type));
    }

    @Override
    public <T> Encoding.Deserializer<T> deserializer(TypeMarker<T> type) {
        return new TracedDeserializer<T>(this.encoding.deserializer(type), DESERIALIZE_OPERATION, this.getTags(type));
    }

    @Override
    public <T> Encoding.Deserializer<T> deserializer(TypeMarker<T> type, Endpoint endpoint) {
        return new TracedDeserializer<T>(this.encoding.deserializer(type, endpoint), DESERIALIZE_OPERATION, this.getTags(type));
    }

    static String toString(TypeMarker<?> typeMarker) {
        Type type = typeMarker.getType();
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        return type.toString();
    }

    @Override
    public String getContentType() {
        return this.encoding.getContentType();
    }

    @Override
    public boolean supportsContentType(String contentType) {
        return this.encoding.supportsContentType(contentType);
    }

    private <T> ImmutableMap<String, String> getTags(TypeMarker<T> type) {
        return ImmutableMap.of((Object)"type", (Object)TracedEncoding.toString(type), (Object)"contentType", (Object)this.getContentType());
    }

    private static final class TracedSerializer<T>
    implements Encoding.Serializer<T> {
        private final Encoding.Serializer<T> delegate;
        private final String operation;
        private final ImmutableMap<String, String> tags;

        TracedSerializer(Encoding.Serializer<T> delegate, String operation, ImmutableMap<String, String> tags) {
            this.delegate = delegate;
            this.operation = operation;
            this.tags = tags;
        }

        @Override
        public void serialize(T value, OutputStream output) throws IOException {
            Tracer.fastStartSpan((String)this.operation);
            try {
                this.delegate.serialize(value, output);
            }
            finally {
                Tracer.fastCompleteSpan(this.tags);
            }
        }
    }

    private static final class TracedDeserializer<T>
    implements Encoding.Deserializer<T> {
        private final Encoding.Deserializer<T> delegate;
        private final String operation;
        private final ImmutableMap<String, String> tags;

        TracedDeserializer(Encoding.Deserializer<T> delegate, String operation, ImmutableMap<String, String> tags) {
            this.delegate = delegate;
            this.operation = operation;
            this.tags = tags;
        }

        @Override
        public T deserialize(InputStream input) throws IOException {
            Tracer.fastStartSpan((String)this.operation);
            try {
                T t = this.delegate.deserialize(input);
                return t;
            }
            finally {
                Tracer.fastCompleteSpan(this.tags);
            }
        }
    }
}

