/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import java.util.function.Consumer;

public final class SafeExchangeCompletionListener
implements ExchangeCompletionListener {
    private static final SafeLogger log = SafeLoggerFactory.get(SafeExchangeCompletionListener.class);
    private final Consumer<HttpServerExchange> action;

    private SafeExchangeCompletionListener(Consumer<HttpServerExchange> action) {
        this.action = action;
    }

    public static ExchangeCompletionListener of(Consumer<HttpServerExchange> action) {
        return new SafeExchangeCompletionListener((Consumer)Preconditions.checkNotNull(action, (String)"An action is required"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
        try {
            this.action.accept(exchange);
        }
        catch (Error | RuntimeException e) {
            log.error("ExchangeCompletionListener threw an exception", e);
        }
        finally {
            try {
                nextListener.proceed();
            }
            catch (Error | RuntimeException e) {
                log.error("NextListener.proceed threw an exception", e);
            }
        }
    }
}

