/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.palantir.conjure.java.undertow.runtime.EndpointHandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.URLDecodingHandler;
import io.undertow.util.PathTemplateMatch;
import java.util.Map;
import java.util.Optional;

final class GlobRetainingDecodingHandler
implements HttpHandler {
    static final EndpointHandlerWrapper WRAPPER = endpoint -> {
        URLDecodingHandler decodingHandler = new URLDecodingHandler(endpoint.handler(), "UTF-8");
        return endpoint.template().endsWith("/*") ? Optional.of(new GlobRetainingDecodingHandler(decodingHandler)) : Optional.of(decodingHandler);
    };
    private final URLDecodingHandler next;

    private GlobRetainingDecodingHandler(URLDecodingHandler next) {
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Map pathParams = ((PathTemplateMatch)exchange.getAttachment(PathTemplateMatch.ATTACHMENT_KEY)).getParameters();
        String originalValue = (String)pathParams.get("*");
        this.next.handleRequest(exchange);
        if (originalValue != null) {
            pathParams.put("*", originalValue);
        }
    }

    public String toString() {
        return "GlobRetainingDecodingHandler{" + String.valueOf(this.next) + "}";
    }
}

