/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.palantir.conjure.java.api.errors.CheckedServiceException;
import com.palantir.conjure.java.api.errors.EndpointServiceException;
import com.palantir.conjure.java.api.errors.ErrorType;
import com.palantir.conjure.java.api.errors.RemoteException;
import com.palantir.conjure.java.api.errors.SerializableError;
import com.palantir.conjure.java.api.errors.ServiceException;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

record ConjureError(@JsonProperty(value="errorCode") String errorCode, @JsonProperty(value="errorName") String errorName, @JsonProperty(value="errorInstanceId") String errorInstanceId, @JsonProperty(value="parameters") Map<String, Object> parameters) {
    ConjureError {
        Preconditions.checkNotNull((Object)errorCode, (String)"errorCode cannot be null");
        Preconditions.checkNotNull((Object)errorName, (String)"errorName cannot be null");
        Preconditions.checkNotNull((Object)errorInstanceId, (String)"errorInstanceId cannot be null");
        Preconditions.checkNotNull(parameters, (String)"parameters cannot be null");
    }

    static ConjureError fromCheckedServiceException(CheckedServiceException exception) {
        Map<String, Object> parameters = ConjureError.getParametersFromArgs(exception.getArgs());
        return new ConjureError(exception.getErrorType().code().name(), exception.getErrorType().name(), exception.getErrorInstanceId(), parameters);
    }

    static ConjureError fromEndpointServiceException(EndpointServiceException exception) {
        Map<String, Object> parameters = ConjureError.getParametersFromArgs(exception.getArgs());
        return new ConjureError(exception.getErrorType().code().name(), exception.getErrorType().name(), exception.getErrorInstanceId(), parameters);
    }

    static ConjureError fromServiceException(ServiceException exception) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Arg arg : exception.getArgs()) {
            parameters.put(arg.getName(), Objects.toString(arg.getValue()));
        }
        ErrorType errorType = exception.getErrorType();
        return new ConjureError(errorType.code().name(), errorType.name(), exception.getErrorInstanceId(), parameters);
    }

    static ConjureError fromServiceExceptionWithJsonSerializedParameterValues(ServiceException exception) {
        Map<String, Object> parameters = ConjureError.getParametersFromArgs(exception.getArgs());
        ErrorType errorType = exception.getErrorType();
        return new ConjureError(errorType.code().name(), errorType.name(), exception.getErrorInstanceId(), parameters);
    }

    static ConjureError fromRemoteException(RemoteException exception) {
        SerializableError error = exception.getError();
        return new ConjureError(error.errorCode(), error.errorName(), error.errorInstanceId(), Collections.emptyMap());
    }

    private static boolean shouldIncludeArgInParameters(Arg<?> arg) {
        OptionalDouble optionalDouble;
        OptionalLong optionalLong;
        OptionalInt optionalInt;
        Object obj = arg.getValue();
        return !(obj == null || obj instanceof Optional && !((Optional)obj).isPresent() || obj instanceof OptionalInt && !(optionalInt = (OptionalInt)obj).isPresent() || obj instanceof OptionalLong && !(optionalLong = (OptionalLong)obj).isPresent() || obj instanceof OptionalDouble && !(optionalDouble = (OptionalDouble)obj).isPresent());
    }

    private static Map<String, Object> getParametersFromArgs(Iterable<Arg<?>> args) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Arg<?> arg : args) {
            if (!ConjureError.shouldIncludeArgInParameters(arg)) continue;
            parameters.put(arg.getName(), arg.getValue());
        }
        return parameters;
    }
}

