/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.palantir.conjure.java.api.errors.ErrorType;
import com.palantir.conjure.java.api.errors.ServiceException;
import com.palantir.conjure.java.undertow.lib.AuthorizationExtractor;
import com.palantir.conjure.java.undertow.lib.PlainSerDe;
import com.palantir.conjure.java.undertow.runtime.Attachments;
import com.palantir.conjure.java.undertow.runtime.JsonWebTokenHandler;
import com.palantir.logsafe.Arg;
import com.palantir.tokens.auth.AuthHeader;
import com.palantir.tokens.auth.BearerToken;
import com.palantir.tokens.auth.UnverifiedJsonWebToken;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.MDC;

final class ConjureAuthorizationExtractor
implements AuthorizationExtractor {
    private static final String USER_ID_KEY = "userId";
    private static final String SESSION_ID_KEY = "sessionId";
    private static final String TOKEN_ID_KEY = "tokenId";
    private static final String ORGANIZATION_ID_KEY = "organizationId";
    private static final Consumer<String> sessionIdSetter = sessionId -> MDC.put((String)SESSION_ID_KEY, (String)sessionId);
    private static final Consumer<String> tokenIdSetter = tokenId -> MDC.put((String)TOKEN_ID_KEY, (String)tokenId);
    private static final Consumer<String> organizationIdSetter = organizationId -> MDC.put((String)ORGANIZATION_ID_KEY, (String)organizationId);
    private static final ErrorType MISSING_CREDENTIAL_ERROR_TYPE = ErrorType.create((ErrorType.Code)ErrorType.Code.UNAUTHORIZED, (String)"Conjure:MissingCredentials");
    private static final ErrorType MALFORMED_CREDENTIAL_ERROR_TYPE = ErrorType.create((ErrorType.Code)ErrorType.Code.UNAUTHORIZED, (String)"Conjure:MalformedCredentials");
    private final PlainSerDe plainSerDe;
    private final JsonWebTokenHandler jsonWebTokenHandler;

    ConjureAuthorizationExtractor(PlainSerDe plainSerDe, JsonWebTokenHandler jsonWebTokenHandler) {
        this.plainSerDe = plainSerDe;
        this.jsonWebTokenHandler = jsonWebTokenHandler;
    }

    public AuthHeader header(HttpServerExchange exchange) {
        AuthHeader authHeader = ConjureAuthorizationExtractor.parseAuthHeader(exchange);
        return this.setState(exchange, authHeader);
    }

    public BearerToken cookie(HttpServerExchange exchange, String cookieName) {
        Cookie cookie = (Cookie)exchange.getRequestCookies().get(cookieName);
        if (cookie == null) {
            throw new ServiceException(MISSING_CREDENTIAL_ERROR_TYPE, new Arg[0]);
        }
        try {
            return this.setState(exchange, this.plainSerDe.deserializeBearerToken(cookie.getValue()));
        }
        catch (RuntimeException e) {
            throw new ServiceException(MALFORMED_CREDENTIAL_ERROR_TYPE, (Throwable)e, new Arg[0]);
        }
    }

    public void setRequestToken(HttpServerExchange exchange, Optional<UnverifiedJsonWebToken> parsedJwt) {
        exchange.putAttachment(Attachments.UNVERIFIED_JWT, parsedJwt);
        if (parsedJwt.isPresent()) {
            UnverifiedJsonWebToken jwt = parsedJwt.get();
            MDC.put((String)USER_ID_KEY, (String)jwt.getUnverifiedUserId());
            jwt.getUnverifiedSessionId().ifPresent(sessionIdSetter);
            jwt.getUnverifiedTokenId().ifPresent(tokenIdSetter);
            jwt.getUnverifiedOrganizationId().ifPresent(organizationIdSetter);
        }
        this.jsonWebTokenHandler.handle(exchange, parsedJwt);
    }

    private BearerToken setState(HttpServerExchange exchange, BearerToken token) {
        Optional parsedJwt = UnverifiedJsonWebToken.tryParse((String)token.getToken());
        this.setRequestToken(exchange, parsedJwt);
        return token;
    }

    private AuthHeader setState(HttpServerExchange exchange, AuthHeader authHeader) {
        this.setState(exchange, authHeader.getBearerToken());
        return authHeader;
    }

    private static AuthHeader parseAuthHeader(HttpServerExchange exchange) {
        HeaderValues authorization = exchange.getRequestHeaders().get(Headers.AUTHORIZATION);
        if (authorization == null) {
            throw new ServiceException(MISSING_CREDENTIAL_ERROR_TYPE, new Arg[0]);
        }
        if (authorization.size() != 1) {
            throw new ServiceException(MALFORMED_CREDENTIAL_ERROR_TYPE, new Arg[0]);
        }
        try {
            return AuthHeader.valueOf((String)authorization.get(0));
        }
        catch (RuntimeException e) {
            throw new ServiceException(MALFORMED_CREDENTIAL_ERROR_TYPE, (Throwable)e, new Arg[0]);
        }
    }
}

