/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.config.ssl;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableSet;
import com.palantir.conjure.java.api.config.ssl.ImmutableSslConfiguration;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.DoNotLog;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.nio.file.Path;
import java.util.Optional;
import org.immutables.value.Value;

@DoNotLog
@JsonDeserialize(builder=Builder.class)
@Value.Immutable
public abstract class SslConfiguration {
    private static final ImmutableSet<String> PEM_EXTENSIONS = ImmutableSet.of((Object)"key", (Object)"pem", (Object)"cer", (Object)"crt");

    @JsonAlias(value={"trust-store-path"})
    public abstract Path trustStorePath();

    @JsonAlias(value={"trust-store-type"})
    @Value.Default
    public StoreType trustStoreType() {
        if (this.isPemExtension(this.trustStorePath())) {
            return StoreType.PEM;
        }
        return StoreType.JKS;
    }

    @JsonAlias(value={"key-store-path"})
    public abstract Optional<Path> keyStorePath();

    @DoNotLog
    @JsonAlias(value={"key-store-password"})
    @Value.Redacted
    public abstract Optional<String> keyStorePassword();

    @JsonAlias(value={"key-store-type"})
    @Value.Default
    public StoreType keyStoreType() {
        if (this.keyStorePath().map(this::isPemExtension).orElse(false).booleanValue()) {
            return StoreType.PEM;
        }
        return StoreType.JKS;
    }

    @JsonAlias(value={"key-store-key-alias"})
    public abstract Optional<String> keyStoreKeyAlias();

    @Value.Check
    protected final void check() {
        if (this.keyStorePassword().isPresent() && !this.keyStorePath().isPresent()) {
            throw new SafeIllegalArgumentException("keyStorePath must be present if a keyStorePassword is provided", new Arg[0]);
        }
        if (this.keyStorePath().isPresent() && this.keyStoreType().equals((Object)StoreType.JKS) && !this.keyStorePassword().isPresent()) {
            throw new SafeIllegalArgumentException("keyStorePassword must be present if keyStoreType is JKS", new Arg[0]);
        }
        if (this.keyStoreKeyAlias().isPresent() && !this.keyStorePath().isPresent()) {
            throw new SafeIllegalArgumentException("keyStorePath must be present if keyStoreKeyAlias is present", new Arg[0]);
        }
    }

    protected final boolean isPemExtension(Path filePath) {
        return PEM_EXTENSIONS.stream().anyMatch(ext -> filePath.getFileName().toString().endsWith((String)ext));
    }

    public static SslConfiguration of(Path trustStorePath) {
        return SslConfiguration.builder().trustStorePath(trustStorePath).build();
    }

    public static SslConfiguration of(Path trustStorePath, Path keyStorePath, String keyStorePassword) {
        return SslConfiguration.builder().trustStorePath(trustStorePath).keyStorePath(keyStorePath).keyStorePassword(keyStorePassword).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum StoreType {
        JKS,
        PEM,
        PKCS12,
        PUPPET;

    }

    public static final class Builder
    extends ImmutableSslConfiguration.Builder {
    }
}

