/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.computemodules.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.palantir.computemodules.client.Client;
import com.palantir.computemodules.client.ComputeModuleJob;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public final class TestClient
implements Client {
    private static final ObjectMapper mapper = new ObjectMapper();
    private BlockingQueue<ComputeModuleJob> jobs = new LinkedBlockingQueue<ComputeModuleJob>();
    private Map<String, BlockingQueue<InputStream>> results = new ConcurrentHashMap<String, BlockingQueue<InputStream>>();

    @Override
    public Optional<ComputeModuleJob> getJob() {
        try {
            return Optional.of(this.jobs.take());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void postResult(String jobId, InputStream result) {
        try {
            Optional.ofNullable(this.results.get(jobId)).orElseThrow().put(result);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public <I> InputStream execute(String queryType, I input) {
        return this.result(this.submit(queryType, input));
    }

    public <I, O> O execute(String queryType, I input, Class<O> outputType) {
        return this.result(this.submit(queryType, input), outputType);
    }

    public <I> String submit(String queryType, I input) {
        String jobId = UUID.randomUUID().toString();
        this.results.put(jobId, new ArrayBlockingQueue(1));
        try {
            this.jobs.put(new ComputeModuleJob(jobId, queryType, input));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return jobId;
    }

    public InputStream result(String jobId) {
        try {
            return Optional.ofNullable(this.results.get(jobId)).orElseThrow().take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public <O> O result(String jobId, Class<O> outputType) {
        try {
            return (O)mapper.readValue(Optional.ofNullable(this.results.get(jobId)).orElseThrow().take(), outputType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

