/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.computemodules.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.palantir.computemodules.client.ComputeModuleJob;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.Optional;

public final class TaggedJobDeserializer {
    private static final SafeLogger log = SafeLoggerFactory.get(TaggedJobDeserializer.class);
    private static final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public Optional<ComputeModuleJob> deserialize(String raw) {
        try {
            ComputeModuleJob job = (ComputeModuleJob)mapper.readValue(raw, ComputeModuleJob.class);
            return Optional.of(job);
        }
        catch (Exception e) {
            log.error("Failed to deserialize job", (Arg)SafeArg.of((String)"raw", (Object)raw), (Throwable)e);
            return Optional.empty();
        }
    }
}

