/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.limits;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.limits.Quotas;
import com.oracle.bmc.limits.QuotasPaginators;
import com.oracle.bmc.limits.QuotasWaiters;
import com.oracle.bmc.limits.internal.http.CreateQuotaConverter;
import com.oracle.bmc.limits.internal.http.DeleteQuotaConverter;
import com.oracle.bmc.limits.internal.http.GetQuotaConverter;
import com.oracle.bmc.limits.internal.http.ListQuotasConverter;
import com.oracle.bmc.limits.internal.http.UpdateQuotaConverter;
import com.oracle.bmc.limits.requests.CreateQuotaRequest;
import com.oracle.bmc.limits.requests.DeleteQuotaRequest;
import com.oracle.bmc.limits.requests.GetQuotaRequest;
import com.oracle.bmc.limits.requests.ListQuotasRequest;
import com.oracle.bmc.limits.requests.UpdateQuotaRequest;
import com.oracle.bmc.limits.responses.CreateQuotaResponse;
import com.oracle.bmc.limits.responses.DeleteQuotaResponse;
import com.oracle.bmc.limits.responses.GetQuotaResponse;
import com.oracle.bmc.limits.responses.ListQuotasResponse;
import com.oracle.bmc.limits.responses.UpdateQuotaResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotasClient
implements Quotas {
    private static final Logger LOG = LoggerFactory.getLogger(QuotasClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("QUOTAS").serviceEndpointPrefix("").serviceEndpointTemplate("https://limits.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final QuotasWaiters waiters;
    private final QuotasPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public QuotasClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public QuotasClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public QuotasClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public QuotasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public QuotasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public QuotasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public QuotasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public QuotasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected QuotasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Quotas-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new QuotasWaiters(executorService, this);
        this.paginators = new QuotasPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public CreateQuotaResponse createQuota(CreateQuotaRequest request) {
        LOG.trace("Called createQuota");
        CreateQuotaRequest interceptedRequest = CreateQuotaConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateQuotaConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateQuotaResponse> transformer = CreateQuotaConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateQuotaResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateQuotaResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateQuotaDetails(), (BmcRequest)retriedRequest);
                return (CreateQuotaResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteQuotaResponse deleteQuota(DeleteQuotaRequest request) {
        LOG.trace("Called deleteQuota");
        DeleteQuotaRequest interceptedRequest = DeleteQuotaConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteQuotaConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteQuotaResponse> transformer = DeleteQuotaConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteQuotaResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteQuotaResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteQuotaResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetQuotaResponse getQuota(GetQuotaRequest request) {
        LOG.trace("Called getQuota");
        GetQuotaRequest interceptedRequest = GetQuotaConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetQuotaConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetQuotaResponse> transformer = GetQuotaConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetQuotaResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetQuotaResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetQuotaResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListQuotasResponse listQuotas(ListQuotasRequest request) {
        LOG.trace("Called listQuotas");
        ListQuotasRequest interceptedRequest = ListQuotasConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListQuotasConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListQuotasResponse> transformer = ListQuotasConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListQuotasResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListQuotasResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListQuotasResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateQuotaResponse updateQuota(UpdateQuotaRequest request) {
        LOG.trace("Called updateQuota");
        UpdateQuotaRequest interceptedRequest = UpdateQuotaConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateQuotaConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateQuotaResponse> transformer = UpdateQuotaConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateQuotaResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateQuotaResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateQuotaDetails(), (BmcRequest)retriedRequest);
                return (UpdateQuotaResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public QuotasWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public QuotasPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, QuotasClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public QuotasClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new QuotasClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

