/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferPackageAsync;
import com.oracle.bmc.dts.internal.http.AttachDevicesToTransferPackageConverter;
import com.oracle.bmc.dts.internal.http.CreateTransferPackageConverter;
import com.oracle.bmc.dts.internal.http.DeleteTransferPackageConverter;
import com.oracle.bmc.dts.internal.http.DetachDevicesFromTransferPackageConverter;
import com.oracle.bmc.dts.internal.http.GetTransferPackageConverter;
import com.oracle.bmc.dts.internal.http.ListTransferPackagesConverter;
import com.oracle.bmc.dts.internal.http.UpdateTransferPackageConverter;
import com.oracle.bmc.dts.requests.AttachDevicesToTransferPackageRequest;
import com.oracle.bmc.dts.requests.CreateTransferPackageRequest;
import com.oracle.bmc.dts.requests.DeleteTransferPackageRequest;
import com.oracle.bmc.dts.requests.DetachDevicesFromTransferPackageRequest;
import com.oracle.bmc.dts.requests.GetTransferPackageRequest;
import com.oracle.bmc.dts.requests.ListTransferPackagesRequest;
import com.oracle.bmc.dts.requests.UpdateTransferPackageRequest;
import com.oracle.bmc.dts.responses.AttachDevicesToTransferPackageResponse;
import com.oracle.bmc.dts.responses.CreateTransferPackageResponse;
import com.oracle.bmc.dts.responses.DeleteTransferPackageResponse;
import com.oracle.bmc.dts.responses.DetachDevicesFromTransferPackageResponse;
import com.oracle.bmc.dts.responses.GetTransferPackageResponse;
import com.oracle.bmc.dts.responses.ListTransferPackagesResponse;
import com.oracle.bmc.dts.responses.UpdateTransferPackageResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferPackageAsyncClient
implements TransferPackageAsync {
    private static final Logger LOG = LoggerFactory.getLogger(TransferPackageAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERPACKAGE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public TransferPackageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public TransferPackageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public TransferPackageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public TransferPackageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public TransferPackageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public TransferPackageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public TransferPackageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public TransferPackageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<AttachDevicesToTransferPackageResponse> attachDevicesToTransferPackage(AttachDevicesToTransferPackageRequest request, AsyncHandler<AttachDevicesToTransferPackageRequest, AttachDevicesToTransferPackageResponse> handler) {
        LOG.trace("Called async attachDevicesToTransferPackage");
        AttachDevicesToTransferPackageRequest interceptedRequest = AttachDevicesToTransferPackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AttachDevicesToTransferPackageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AttachDevicesToTransferPackageResponse> transformer = AttachDevicesToTransferPackageConverter.fromResponse();
        AsyncHandler<AttachDevicesToTransferPackageRequest, AttachDevicesToTransferPackageResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AttachDevicesToTransferPackageRequest, AttachDevicesToTransferPackageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateTransferPackageResponse> createTransferPackage(CreateTransferPackageRequest request, AsyncHandler<CreateTransferPackageRequest, CreateTransferPackageResponse> handler) {
        LOG.trace("Called async createTransferPackage");
        CreateTransferPackageRequest interceptedRequest = CreateTransferPackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTransferPackageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTransferPackageResponse> transformer = CreateTransferPackageConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateTransferPackageRequest, CreateTransferPackageResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateTransferPackageRequest, CreateTransferPackageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteTransferPackageResponse> deleteTransferPackage(DeleteTransferPackageRequest request, AsyncHandler<DeleteTransferPackageRequest, DeleteTransferPackageResponse> handler) {
        LOG.trace("Called async deleteTransferPackage");
        DeleteTransferPackageRequest interceptedRequest = DeleteTransferPackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTransferPackageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTransferPackageResponse> transformer = DeleteTransferPackageConverter.fromResponse();
        AsyncHandler<DeleteTransferPackageRequest, DeleteTransferPackageResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteTransferPackageRequest, DeleteTransferPackageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DetachDevicesFromTransferPackageResponse> detachDevicesFromTransferPackage(DetachDevicesFromTransferPackageRequest request, AsyncHandler<DetachDevicesFromTransferPackageRequest, DetachDevicesFromTransferPackageResponse> handler) {
        LOG.trace("Called async detachDevicesFromTransferPackage");
        DetachDevicesFromTransferPackageRequest interceptedRequest = DetachDevicesFromTransferPackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetachDevicesFromTransferPackageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DetachDevicesFromTransferPackageResponse> transformer = DetachDevicesFromTransferPackageConverter.fromResponse();
        AsyncHandler<DetachDevicesFromTransferPackageRequest, DetachDevicesFromTransferPackageResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DetachDevicesFromTransferPackageRequest, DetachDevicesFromTransferPackageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTransferPackageResponse> getTransferPackage(GetTransferPackageRequest request, AsyncHandler<GetTransferPackageRequest, GetTransferPackageResponse> handler) {
        LOG.trace("Called async getTransferPackage");
        GetTransferPackageRequest interceptedRequest = GetTransferPackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTransferPackageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTransferPackageResponse> transformer = GetTransferPackageConverter.fromResponse();
        AsyncHandler<GetTransferPackageRequest, GetTransferPackageResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTransferPackageRequest, GetTransferPackageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTransferPackagesResponse> listTransferPackages(ListTransferPackagesRequest request, AsyncHandler<ListTransferPackagesRequest, ListTransferPackagesResponse> handler) {
        LOG.trace("Called async listTransferPackages");
        ListTransferPackagesRequest interceptedRequest = ListTransferPackagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTransferPackagesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTransferPackagesResponse> transformer = ListTransferPackagesConverter.fromResponse();
        AsyncHandler<ListTransferPackagesRequest, ListTransferPackagesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTransferPackagesRequest, ListTransferPackagesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateTransferPackageResponse> updateTransferPackage(UpdateTransferPackageRequest request, AsyncHandler<UpdateTransferPackageRequest, UpdateTransferPackageResponse> handler) {
        LOG.trace("Called async updateTransferPackage");
        UpdateTransferPackageRequest interceptedRequest = UpdateTransferPackageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTransferPackageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTransferPackageResponse> transformer = UpdateTransferPackageConverter.fromResponse();
        AsyncHandler<UpdateTransferPackageRequest, UpdateTransferPackageResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateTransferPackageRequest, UpdateTransferPackageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferPackageAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public TransferPackageAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new TransferPackageAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

