/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.dts.TransferJob;
import com.oracle.bmc.dts.model.TransferJob;
import com.oracle.bmc.dts.requests.GetTransferJobRequest;
import com.oracle.bmc.dts.responses.GetTransferJobResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class TransferJobWaiters {
    private final ExecutorService executorService;
    private final TransferJob client;

    public Waiter<GetTransferJobRequest, GetTransferJobResponse> forTransferJob(GetTransferJobRequest request, TransferJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTransferJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTransferJobRequest, GetTransferJobResponse> forTransferJob(GetTransferJobRequest request, TransferJob.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTransferJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTransferJobRequest, GetTransferJobResponse> forTransferJob(GetTransferJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, TransferJob.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTransferJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTransferJobRequest, GetTransferJobResponse> forTransferJob(BmcGenericWaiter waiter, GetTransferJobRequest request, TransferJob.LifecycleState ... targetStates) {
        final HashSet<TransferJob.LifecycleState> targetStatesSet = new HashSet<TransferJob.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetTransferJobRequest, GetTransferJobResponse>(){

            public GetTransferJobResponse apply(GetTransferJobRequest request) {
                return TransferJobWaiters.this.client.getTransferJob(request);
            }
        }, (Predicate)new Predicate<GetTransferJobResponse>(){

            public boolean apply(GetTransferJobResponse response) {
                return targetStatesSet.contains((Object)response.getTransferJob().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)TransferJob.LifecycleState.Deleted)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public TransferJobWaiters(ExecutorService executorService, TransferJob client) {
        this.executorService = executorService;
        this.client = client;
    }
}

