/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.bds.model.AutoScalingConfiguration;
import com.oracle.bmc.bds.model.SortOrders;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListAutoScalingConfigurationsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String bdsInstanceId;
    private String page;
    private Integer limit;
    private SortBy sortBy;
    private SortOrders sortOrder;
    private String displayName;
    private AutoScalingConfiguration.LifecycleState lifecycleState;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "bdsInstanceId", "page", "limit", "sortBy", "sortOrder", "displayName", "lifecycleState", "opcRequestId"})
    ListAutoScalingConfigurationsRequest(String compartmentId, String bdsInstanceId, String page, Integer limit, SortBy sortBy, SortOrders sortOrder, String displayName, AutoScalingConfiguration.LifecycleState lifecycleState, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.bdsInstanceId = bdsInstanceId;
        this.page = page;
        this.limit = limit;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.displayName = displayName;
        this.lifecycleState = lifecycleState;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getBdsInstanceId() {
        return this.bdsInstanceId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public AutoScalingConfiguration.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAutoScalingConfigurationsRequest, Void> {
        private String compartmentId;
        private String bdsInstanceId;
        private String page;
        private Integer limit;
        private SortBy sortBy;
        private SortOrders sortOrder;
        private String displayName;
        private AutoScalingConfiguration.LifecycleState lifecycleState;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAutoScalingConfigurationsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.bdsInstanceId(o.getBdsInstanceId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.displayName(o.getDisplayName());
            this.lifecycleState(o.getLifecycleState());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAutoScalingConfigurationsRequest build() {
            ListAutoScalingConfigurationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder bdsInstanceId(String bdsInstanceId) {
            this.bdsInstanceId = bdsInstanceId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder lifecycleState(AutoScalingConfiguration.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListAutoScalingConfigurationsRequest buildWithoutInvocationCallback() {
            return new ListAutoScalingConfigurationsRequest(this.compartmentId, this.bdsInstanceId, this.page, this.limit, this.sortBy, this.sortOrder, this.displayName, this.lifecycleState, this.opcRequestId);
        }

        public String toString() {
            return "ListAutoScalingConfigurationsRequest.Builder(compartmentId=" + this.compartmentId + ", bdsInstanceId=" + this.bdsInstanceId + ", page=" + this.page + ", limit=" + this.limit + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", displayName=" + this.displayName + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

