/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetBdsInstanceRequest
extends BmcRequest<Void> {
    private String bdsInstanceId;
    private String opcRequestId;

    @ConstructorProperties(value={"bdsInstanceId", "opcRequestId"})
    GetBdsInstanceRequest(String bdsInstanceId, String opcRequestId) {
        this.bdsInstanceId = bdsInstanceId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getBdsInstanceId() {
        return this.bdsInstanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetBdsInstanceRequest, Void> {
        private String bdsInstanceId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetBdsInstanceRequest o) {
            this.bdsInstanceId(o.getBdsInstanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetBdsInstanceRequest build() {
            GetBdsInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder bdsInstanceId(String bdsInstanceId) {
            this.bdsInstanceId = bdsInstanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetBdsInstanceRequest buildWithoutInvocationCallback() {
            return new GetBdsInstanceRequest(this.bdsInstanceId, this.opcRequestId);
        }

        public String toString() {
            return "GetBdsInstanceRequest.Builder(bdsInstanceId=" + this.bdsInstanceId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

